/*
 * Decompiled with CFR 0.152.
 */
package principal.sprites;

import java.awt.image.BufferedImage;
import principal.herramientas.CargadorRecursos;
import principal.sprites.Sprite;

public class HojaSprites {
    private final int anchoHojaPixeles;
    private final int altoHojaPixeles;
    private final int anchoHojaSprites;
    private final int altoHojaSprites;
    private final int anchoSprites;
    private final int altoSprites;
    private Sprite[] sprites;

    public HojaSprites(String ruta, int ladoSprites, boolean hojaOpaca) {
        BufferedImage imagen = hojaOpaca ? CargadorRecursos.cargarImagenCompatibleOpaca(ruta) : CargadorRecursos.cargarImagenCompatibleTranslucida(ruta);
        this.anchoHojaPixeles = imagen.getWidth();
        this.altoHojaPixeles = imagen.getHeight();
        this.anchoHojaSprites = this.anchoHojaPixeles / ladoSprites;
        this.altoHojaSprites = this.altoHojaPixeles / ladoSprites;
        this.anchoSprites = ladoSprites;
        this.altoSprites = ladoSprites;
        this.sprites = new Sprite[this.anchoHojaSprites * this.altoHojaSprites];
        this.extraerSprites(imagen);
    }

    public HojaSprites(String ruta, int anchoSprites, int altoSprites, boolean hojaOpaca) {
        BufferedImage imagen = hojaOpaca ? CargadorRecursos.cargarImagenCompatibleOpaca(ruta) : CargadorRecursos.cargarImagenCompatibleTranslucida(ruta);
        this.anchoHojaPixeles = imagen.getWidth();
        this.altoHojaPixeles = imagen.getHeight();
        this.anchoHojaSprites = this.anchoHojaPixeles / anchoSprites;
        this.altoHojaSprites = this.altoHojaPixeles / altoSprites;
        this.anchoSprites = anchoSprites;
        this.altoSprites = altoSprites;
        this.sprites = new Sprite[this.anchoHojaSprites * this.altoHojaSprites];
        this.extraerSprites(imagen);
    }

    private void extraerSprites(BufferedImage imagen) {
        int y = 0;
        while (y < this.altoHojaSprites) {
            int x = 0;
            while (x < this.anchoHojaSprites) {
                int posicionX = x * this.anchoSprites;
                int posicionY = y * this.altoSprites;
                this.sprites[x + y * this.anchoHojaSprites] = new Sprite(imagen.getSubimage(posicionX, posicionY, this.anchoSprites, this.altoSprites));
                ++x;
            }
            ++y;
        }
    }

    public Sprite getSprite(int indice) {
        return this.sprites[indice];
    }

    public Sprite getSprite(int x, int y) {
        return this.sprites[x + y * this.anchoHojaSprites];
    }
}

