/*
 * Decompiled with CFR 0.152.
 */
package principal.sonido;

import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import principal.herramientas.CargadorRecursos;

public class Sonido {
    public final Clip sonido;
    public String nombre;
    public float volumen;

    public Sonido(String ruta, String nombre, float volumen) {
        this.nombre = nombre;
        this.volumen = volumen;
        this.sonido = CargadorRecursos.cargarSonido("sonidos/" + ruta);
        FloatControl volumeControl = (FloatControl)this.sonido.getControl(FloatControl.Type.MASTER_GAIN);
        volumeControl.setValue(volumen);
    }

    public void reproducir() {
        this.sonido.stop();
        this.sonido.flush();
        this.sonido.setMicrosecondPosition(0L);
        this.sonido.start();
    }

    public void repetir() {
        if (!this.sonido.isRunning()) {
            this.sonido.stop();
            this.sonido.flush();
            this.sonido.setMicrosecondPosition(0L);
            this.sonido.loop(-1);
        }
    }

    public long getDuracion() {
        return this.sonido.getMicrosecondLength();
    }

    public void stop() {
        this.sonido.stop();
        this.sonido.flush();
    }

    public void setVolume(float volume) {
        FloatControl volumeControl = (FloatControl)this.sonido.getControl(FloatControl.Type.MASTER_GAIN);
        volumeControl.setValue(volume + this.volumen);
    }

    public long getPosition() {
        return this.sonido.getMicrosecondPosition();
    }
}

