/*
 * Decompiled with CFR 0.152.
 */
package principal.maquinaestado.estados.principal.menus;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import principal.control.GestorControles;
import principal.graficos.SuperficieDibujo;
import principal.herramientas.CargadorRecursos;
import principal.herramientas.DibujoDebug;
import principal.herramientas.T;
import principal.maquinaestado.estados.menu.Menu;

public class MenuCreditos
extends Menu {
    double yOff = 0.0;
    int cooldown = 120;
    BufferedImage[] creditos = new BufferedImage[T.getIntJSON(this.info, "creditos")];
    int creditoActual;

    public MenuCreditos(SuperficieDibujo sd, String ruta) {
        super(sd, ruta);
        String carpetaCreditos = T.getObjetoJSON(this.info.get("rutas").toString()).get("creditos").toString();
        int i = 0;
        while (i < this.creditos.length) {
            this.creditos[i] = CargadorRecursos.cargarImagenCompatibleTranslucida(String.valueOf(carpetaCreditos) + i + ".png");
            ++i;
        }
    }

    @Override
    public void actualizar() {
        super.actualizar();
        this.siguienteMenu = GestorControles.teclado.atras ? "" : "creditos";
        if (this.yOff > (double)this.creditos[this.creditoActual].getHeight()) {
            if (this.creditoActual + 1 >= this.creditos.length) {
                this.siguienteMenu = "";
                this.creditoActual = 0;
            } else {
                ++this.creditoActual;
            }
            this.yOff = 0.0;
            this.cooldown = 120;
        }
        if (this.cooldown <= 0) {
            this.yOff += 0.5;
        } else {
            --this.cooldown;
        }
    }

    @Override
    public void dibujar(Graphics g) {
        super.dibujar(g);
        DibujoDebug.dibujarImagen(g, this.creditos[this.creditoActual], 0, (int)(0.0 - this.yOff));
    }
}

