/*
 * Decompiled with CFR 0.152.
 */
package principal.maquinaestado.estados.menu.menus;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import principal.ElementosPrincipales;
import principal.control.GestorControles;
import principal.elementos_jugador.Estado;
import principal.graficos.SuperficieDibujo;
import principal.herramientas.DibujoDebug;
import principal.herramientas.T;
import principal.maquinaestado.estados.menu.Menu;

public class MenuEstado
extends Menu {
    public String[] textos;
    public Point[] puntosTexto;

    public MenuEstado(SuperficieDibujo sd) {
        super(sd, "menu/estado/estado.json");
        this.siguienteMenu = "estado";
        JSONArray textosInfo = (JSONArray)this.info.get("textos");
        this.textos = new String[textosInfo.size()];
        this.puntosTexto = new Point[textosInfo.size()];
        int i = 0;
        while (i < textosInfo.size()) {
            JSONObject textoInfo = (JSONObject)textosInfo.get(i);
            this.textos[i] = (String)textoInfo.get("texto");
            int x = T.getIntJSON(textoInfo, "x");
            int y = T.getIntJSON(textoInfo, "y");
            this.puntosTexto[i] = new Point(x, y);
            ++i;
        }
    }

    @Override
    public void actualizar() {
        super.actualizar();
        this.siguienteMenu = GestorControles.teclado.atras ? "" : "estado";
    }

    @Override
    public void dibujar(Graphics g) {
        super.dibujar(g);
        Estado estado = ElementosPrincipales.jugador.estado;
        DibujoDebug.dibujarString(g, this.textos[0], this.puntosTexto[0], Color.white);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[1]) + estado.nombre, this.puntosTexto[1]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[2]) + estado.nivel, this.puntosTexto[2]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[3]) + estado.exp + "/" + estado.expMax, this.puntosTexto[3]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[4]) + (int)estado.HP + "/" + (int)estado.HPMax, this.puntosTexto[4]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[5]) + (int)estado.MP + "/" + (int)estado.MPMax, this.puntosTexto[5]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[6]) + (int)(estado.Stm / 10.0) + "/" + (int)(estado.StmMax / 10.0), this.puntosTexto[6]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[7]) + (int)(estado.Cal / 20000.0) + "/" + (int)(estado.CalMax / 20000.0), this.puntosTexto[7]);
        DibujoDebug.dibujarString(g, this.textos[8], this.puntosTexto[8]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[9]) + estado.vitalidad, this.puntosTexto[9]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[10]) + estado.strenght, this.puntosTexto[10]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[11]) + estado.agilidad, this.puntosTexto[11]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[12]) + estado.sentidos, this.puntosTexto[12]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[13]) + estado.inteligencia, this.puntosTexto[13]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[14]) + estado.wisdom, this.puntosTexto[14]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[15]) + estado.luck, this.puntosTexto[15]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[16]) + estado.charm, this.puntosTexto[16]);
        DibujoDebug.dibujarString(g, String.valueOf(this.textos[17]) + estado.puntosEstado, this.puntosTexto[17]);
    }
}

