/*
 * Decompiled with CFR 0.152.
 */
package principal.maquinaestado.estados.menu;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import principal.ElementosPrincipales;
import principal.GestorPrincipal;
import principal.control.GestorControles;
import principal.elementos_jugador.Estado;
import principal.graficos.SuperficieDibujo;
import principal.herramientas.CargadorRecursos;
import principal.herramientas.DibujoDebug;
import principal.herramientas.T;
import principal.maquinaestado.GestorEstados;
import principal.maquinaestado.estados.menu.Boton;
import principal.maquinaestado.estados.menu.ButonCluster;
import principal.maquinaestado.estados.principal.GestorMenuPrincipal;

public class Menu {
    public SuperficieDibujo sd;
    public String siguienteMenu = "";
    public int cooldownSelect;
    public int maxCooldownSelect;
    public JSONObject info;
    public BufferedImage fondo;
    public ArrayList<Boton> botonesMenu;
    public ButonCluster[] butonClusters;

    public Menu(SuperficieDibujo sd, String ruta) {
        String rutaBoton;
        JSONObject botonMeta;
        JSONObject objeto;
        this.sd = sd;
        String principalJSON = CargadorRecursos.leerArchivoTexto(ruta);
        this.info = T.getObjetoJSON(principalJSON);
        JSONObject metadata = (JSONObject)this.info.get("metadata");
        JSONObject rutas = (JSONObject)this.info.get("rutas");
        JSONArray botones = (JSONArray)this.info.get("botones");
        JSONArray clusters = (JSONArray)this.info.get("butonclusters");
        this.botonesMenu = new ArrayList();
        int i = 0;
        while (i < botones.size()) {
            objeto = (JSONObject)botones.get(i);
            botonMeta = (JSONObject)metadata.get(objeto.get("tipo"));
            rutaBoton = (String)rutas.get(objeto.get("tipo"));
            Boton boton = new Boton(objeto, botonMeta, rutaBoton, sd);
            this.botonesMenu.add(boton);
            ++i;
        }
        this.butonClusters = new ButonCluster[clusters.size()];
        i = 0;
        while (i < clusters.size()) {
            ButonCluster botonCluster;
            objeto = (JSONObject)clusters.get(i);
            botonMeta = (JSONObject)metadata.get(objeto.get("tipo"));
            rutaBoton = (String)rutas.get(objeto.get("tipo"));
            this.butonClusters[i] = botonCluster = new ButonCluster(objeto, botonMeta, rutaBoton, sd);
            ++i;
        }
        ButonCluster[] butonClusterArray = this.butonClusters;
        int n = this.butonClusters.length;
        int n2 = 0;
        while (n2 < n) {
            ButonCluster bc = butonClusterArray[n2];
            for (Boton boton : bc.botones) {
                this.botonesMenu.add(boton);
            }
            ++n2;
        }
        this.butonClusters = null;
        this.fondo = CargadorRecursos.cargarImagenCompatibleOpaca((String)rutas.get("fondo"));
        this.maxCooldownSelect = 15;
        this.cooldownSelect = 0;
    }

    public Menu(SuperficieDibujo sd, JSONObject info) {
        String rutaBoton;
        JSONObject botonMeta;
        JSONObject objeto;
        this.sd = sd;
        JSONObject metadata = (JSONObject)info.get("metadata");
        JSONObject rutas = (JSONObject)info.get("rutas");
        JSONArray botones = (JSONArray)info.get("botones");
        JSONArray clusters = (JSONArray)info.get("butonclusters");
        this.botonesMenu = new ArrayList();
        int i = 0;
        while (i < botones.size()) {
            objeto = (JSONObject)botones.get(i);
            botonMeta = (JSONObject)metadata.get(objeto.get("tipo"));
            rutaBoton = (String)rutas.get(objeto.get("tipo"));
            Boton boton = new Boton(objeto, botonMeta, rutaBoton, sd);
            this.botonesMenu.add(boton);
            ++i;
        }
        this.butonClusters = new ButonCluster[clusters.size()];
        i = 0;
        while (i < clusters.size()) {
            ButonCluster botonCluster;
            objeto = (JSONObject)clusters.get(i);
            botonMeta = (JSONObject)metadata.get(objeto.get("tipo"));
            rutaBoton = (String)rutas.get(objeto.get("tipo"));
            this.butonClusters[i] = botonCluster = new ButonCluster(objeto, botonMeta, rutaBoton, sd);
            ++i;
        }
        ButonCluster[] butonClusterArray = this.butonClusters;
        int n = this.butonClusters.length;
        int n2 = 0;
        while (n2 < n) {
            ButonCluster bc = butonClusterArray[n2];
            for (Boton boton : bc.botones) {
                this.botonesMenu.add(boton);
            }
            ++n2;
        }
        this.butonClusters = null;
        this.fondo = CargadorRecursos.cargarImagenCompatibleOpaca((String)rutas.get("fondo"));
        this.maxCooldownSelect = 20;
        this.cooldownSelect = 0;
    }

    public void actualizar() {
        Estado estado = ElementosPrincipales.jugador.estado;
        for (Boton boton : this.botonesMenu) {
            block29: {
                boton.actualizar();
                if (!boton.seleccionado || this.cooldownSelect > 0) break block29;
                block6 : switch (boton.tipo) {
                    case "cambiador": {
                        this.siguienteMenu = boton.funcion;
                        break;
                    }
                    case "sumadorpuntosestado": {
                        estado.actualizarEstadisticas(boton.funcion, true);
                        break;
                    }
                    case "restadorpuntosestado": {
                        estado.actualizarEstadisticas(boton.funcion, false);
                        break;
                    }
                    case "salir": {
                        switch (boton.funcion) {
                            case "menu": {
                                GestorEstados.estado = 1;
                                GestorMenuPrincipal.menuActual.siguienteMenu = "";
                                break block6;
                            }
                            case "juego": {
                                GestorPrincipal.salir();
                                break block6;
                            }
                        }
                        break;
                    }
                }
                this.cooldownSelect = this.maxCooldownSelect;
                break;
            }
            this.siguienteMenu = "";
        }
        if (this.cooldownSelect > 0) {
            --this.cooldownSelect;
        }
        if (!GestorControles.teclado.menu && GestorEstados.estado == 2) {
            GestorEstados.estado = 0;
        }
    }

    public void dibujar(Graphics g) {
        DibujoDebug.dibujarImagen(g, this.fondo, 0, 0);
        for (Boton boton : this.botonesMenu) {
            boton.dibujar(g);
        }
    }
}

