/*
 * Decompiled with CFR 0.152.
 */
package principal.maquinaestado.estados.menu;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.json.simple.JSONObject;
import principal.graficos.SuperficieDibujo;
import principal.herramientas.CargadorRecursos;
import principal.herramientas.DibujoDebug;
import principal.herramientas.T;
import principal.sonido.SoundController;

public class Boton {
    public SuperficieDibujo sd;
    public String nombre;
    public String funcion;
    public Point pos;
    public String tipo;
    public BufferedImage[] imagenes = new BufferedImage[3];
    public BufferedImage imagenActual;
    public boolean seleccionado = false;
    public boolean conRaton = false;
    public boolean toggle = false;
    public boolean dibujarNombre = false;

    public Boton(JSONObject objeto, JSONObject metadata, String ruta, SuperficieDibujo sd) {
        this.nombre = (String)objeto.get("nombre");
        int x = T.getIntJSON(objeto, "x");
        int y = T.getIntJSON(objeto, "y");
        this.pos = new Point(x, y);
        this.tipo = (String)objeto.get("tipo");
        this.funcion = (String)objeto.get("funcion");
        BufferedImage imagen = CargadorRecursos.cargarImagenCompatibleOpaca(ruta);
        int i = 0;
        while (i < this.imagenes.length) {
            JSONObject ubicacionInactivo = switch (i) {
                case 0 -> (JSONObject)metadata.get("inactivo");
                case 1 -> (JSONObject)metadata.get("activo");
                default -> (JSONObject)metadata.get("seleccionado");
            };
            this.imagenes[i] = imagen.getSubimage(T.getIntJSON(ubicacionInactivo, "x"), T.getIntJSON(ubicacionInactivo, "y"), T.getIntJSON(ubicacionInactivo, "ancho"), T.getIntJSON(ubicacionInactivo, "alto"));
            ++i;
        }
        this.imagenActual = this.imagenes[0];
        this.toggle = (Boolean)objeto.get("toggle");
        this.dibujarNombre = (Boolean)objeto.get("dibujarnombre");
        if (SoundController.get("boton") == null) {
            SoundController.crearSonido("boton.wav", "boton", 0.0f);
        }
        this.sd = sd;
    }

    public void actualizar() {
        Rectangle detector = new Rectangle(this.pos.x, this.pos.y, this.imagenActual.getWidth(), this.imagenActual.getHeight());
        if (this.toggle) {
            if (detector.intersects(this.sd.raton.getRectanglePosicionEscalado())) {
                if (this.sd.raton.click) {
                    this.imagenActual = this.imagenes[2];
                    this.seleccionado = !this.seleccionado;
                    SoundController.reproducir("boton");
                } else {
                    this.imagenActual = this.seleccionado ? this.imagenes[2] : this.imagenes[1];
                }
                this.conRaton = true;
            } else {
                this.imagenActual = this.seleccionado ? this.imagenes[2] : this.imagenes[0];
                this.conRaton = false;
            }
        } else if (detector.intersects(this.sd.raton.getRectanglePosicionEscalado())) {
            if (this.sd.raton.click) {
                this.imagenActual = this.imagenes[2];
                this.seleccionado = true;
                SoundController.reproducir("boton");
            } else {
                this.imagenActual = this.imagenes[1];
                this.seleccionado = false;
            }
            this.conRaton = true;
        } else {
            this.imagenActual = this.imagenes[0];
            this.conRaton = false;
            this.seleccionado = false;
        }
    }

    public void dibujar(Graphics g) {
        DibujoDebug.dibujarImagen(g, this.imagenActual, this.pos);
        if (this.dibujarNombre) {
            int x = this.pos.x + (this.imagenActual.getWidth() / 2 - T.MedirAnchoPixeles(g, this.nombre) / 2);
            int y = this.pos.y + (this.imagenActual.getHeight() / 2 + T.MedirAltoPixeles(g, this.nombre) / 2);
            DibujoDebug.dibujarString(g, this.nombre, x, y, Color.white);
        }
    }
}

