/*
 * Decompiled with CFR 0.152.
 */
package principal.maquinaestado.estados.juego;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import principal.Constantes;
import principal.ElementosPrincipales;
import principal.control.GestorControles;
import principal.graficos.SuperficieDibujo;
import principal.herramientas.CargadorRecursos;
import principal.herramientas.DatosDebug;
import principal.interfaz_usuario.GUI;
import principal.mapas.MapaTiled;
import principal.mapas.Puerta;
import principal.maquinaestado.EstadoJuego;
import principal.maquinaestado.GestorEstados;
import principal.sonido.SoundController;

public class GestorJuego
implements EstadoJuego {
    BufferedImage logo;
    public static GUI gui;

    public GestorJuego(SuperficieDibujo sd) {
        gui = new GUI("GUI/GUI.json", sd);
        this.logo = CargadorRecursos.cargarImagenCompatibleOpaca(Constantes.RUTA_LOGO);
    }

    @Override
    public void actualizar() {
        ElementosPrincipales.jugador.actualizar();
        ElementosPrincipales.mapa.actualizar();
        gui.actualizar();
        if (GestorControles.teclado.menu) {
            GestorEstados.estado = 2;
        }
    }

    @Override
    public void dibujar(Graphics g) {
        ElementosPrincipales.mapa.dibujar(g);
        gui.dibujar(g);
        DatosDebug.enviarDato("X = " + ElementosPrincipales.jugador.posX / 32.0);
        DatosDebug.enviarDato("Y = " + ElementosPrincipales.jugador.posY / 32.0);
    }

    public static void cambiarMapa(Puerta puerta) {
        ElementosPrincipales.jugador.posX = puerta.salida.x * 32;
        ElementosPrincipales.jugador.posY = puerta.salida.y * 32;
        SoundController.fadeOut(ElementosPrincipales.mapa.nombre, 2.0f);
        ElementosPrincipales.mapa = new MapaTiled(puerta.ruta);
    }
}

