/*
 * Decompiled with CFR 0.152.
 */
package principal.mapas;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import principal.Constantes;
import principal.ElementosPrincipales;
import principal.control.GestorControles;
import principal.dijkstra.Dijkstra;
import principal.elementos_jugador.inventario.Objeto;
import principal.elementos_jugador.inventario.RegistroElementos;
import principal.entes.Enemigo;
import principal.entes.GeneradorEnemigos;
import principal.entes.RegistroEnemigos;
import principal.herramientas.CargadorRecursos;
import principal.herramientas.DibujoDebug;
import principal.herramientas.T;
import principal.mapas.CapaColosiones;
import principal.mapas.CapaSprites;
import principal.mapas.Puerta;
import principal.mapas.WinCond;
import principal.sonido.SoundController;
import principal.sprites.HojaSprites;
import principal.sprites.Sprite;

public class MapaTiled {
    private int anchoMapaTiles;
    private int altoMapaTiles;
    private int contadorActualizacion = 0;
    public Point puntoInicial;
    private ArrayList<CapaSprites> capasSprites;
    private ArrayList<CapaColosiones> capasColosiones;
    public ArrayList<Rectangle> areasColisionOriginales;
    public ArrayList<Rectangle> areasColisionActualizadas;
    private ArrayList<Objeto> objetosMapa;
    public ArrayList<Enemigo> enemigosMapa;
    public ArrayList<GeneradorEnemigos> generadores;
    private Sprite[] paletaSprites;
    public int capaInicial;
    public Rectangle AreaDij;
    public Dijkstra d = null;
    public Enemigo jefe;
    public boolean tieneJefe = false;
    public boolean tieneMusica = false;
    public ArrayList<Puerta> puertas;
    public WinCond winCond;
    public String nombre;

    public MapaTiled(String ruta) {
        Object rutaMusica;
        String contenido = CargadorRecursos.leerArchivoTexto(ruta);
        this.objetosMapa = new ArrayList();
        JSONObject info = T.getObjetoJSON(contenido);
        this.nombre = T.getPropertie(info, "nombre").toString();
        this.anchoMapaTiles = T.getIntJSON(info, "width");
        this.altoMapaTiles = T.getIntJSON(info, "height");
        this.puntoInicial = new Point(T.toInt(T.getPropertie(info, "x")) * 32, T.toInt(T.getPropertie(info, "y")) * 32);
        this.capaInicial = T.toInt(T.getPropertie(info, "capa"));
        JSONArray capas = T.getArrayJSON(info.get("layers").toString());
        this.capasSprites = new ArrayList();
        this.capasColosiones = new ArrayList();
        this.puertas = new ArrayList();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<Integer> maxs = new ArrayList<Integer>();
        ArrayList<Integer> mins = new ArrayList<Integer>();
        ArrayList<Rectangle> rs = new ArrayList<Rectangle>();
        JSONArray coleccionesSprites = T.getArrayJSON(info.get("tilesets").toString());
        this.generadores = new ArrayList();
        int i = 0;
        while (i < capas.size()) {
            String tipo;
            JSONObject datosCapa = T.getObjetoJSON(capas.get(i).toString());
            int anchoCapa = this.altoMapaTiles;
            int altoCapa = this.anchoMapaTiles;
            int xCapa = T.getIntJSON(datosCapa, "x");
            int yCapa = T.getIntJSON(datosCapa, "y");
            block4 : switch (tipo = datosCapa.get("type").toString()) {
                case "tilelayer": {
                    switch (datosCapa.get("name").toString()) {
                        case "objetos": {
                            altoCapa = T.getIntJSON(datosCapa, "height");
                            anchoCapa = T.getIntJSON(datosCapa, "width");
                            int inicio = 0;
                            JSONArray objetos = T.getArrayJSON(datosCapa.get("data").toString());
                            int k = 0;
                            while (k < coleccionesSprites.size()) {
                                JSONObject datosGrupo = T.getObjetoJSON(coleccionesSprites.get(k).toString());
                                if (datosGrupo.get("name").toString().equals("objetos")) {
                                    inicio = T.getIntJSON(datosGrupo, "firstgid");
                                }
                                ++k;
                            }
                            int y = 0;
                            while (y < altoCapa) {
                                int x = 0;
                                while (x < anchoCapa) {
                                    int codigoObjeto = Integer.parseInt(objetos.get(x + y * anchoCapa).toString());
                                    if (codigoObjeto != 0 && codigoObjeto - inicio != 0) {
                                        this.objetosMapa.add(RegistroElementos.getObjetoMapa(codigoObjeto - inicio, new Point(x, y)));
                                    }
                                    ++x;
                                }
                                ++y;
                            }
                            break block4;
                        }
                        default: {
                            anchoCapa = T.getIntJSON(datosCapa, "width");
                            altoCapa = T.getIntJSON(datosCapa, "height");
                            JSONArray sprites = T.getArrayJSON(datosCapa.get("data").toString());
                            int[] spritesCapa = new int[sprites.size()];
                            int j = 0;
                            while (j < sprites.size()) {
                                int codigoSprite = Integer.parseInt(sprites.get(j).toString());
                                spritesCapa[j] = codigoSprite - 1;
                                ++j;
                            }
                            this.capasSprites.add(new CapaSprites(anchoCapa, altoCapa, xCapa, yCapa, spritesCapa));
                            break;
                        }
                    }
                    break;
                }
                case "objectgroup": {
                    JSONArray rectangulos = T.getArrayJSON(datosCapa.get("objects").toString());
                    ArrayList<Rectangle> rectangulosCapa = new ArrayList<Rectangle>();
                    int j = 0;
                    while (j < rectangulos.size()) {
                        JSONObject datosRectangulo = T.getObjetoJSON(rectangulos.get(j).toString());
                        int x = T.getIntJSON(datosRectangulo, "x");
                        int y = T.getIntJSON(datosRectangulo, "y");
                        int ancho = T.getIntJSON(datosRectangulo, "width");
                        int alto = T.getIntJSON(datosRectangulo, "height");
                        if (x == 0) {
                            x = 1;
                        }
                        if (y == 0) {
                            y = 1;
                        }
                        if (ancho == 0) {
                            ancho = 1;
                        }
                        if (alto == 0) {
                            alto = 1;
                        }
                        Rectangle rectangulo = new Rectangle(x, y, ancho, alto);
                        switch (datosRectangulo.get("type").toString()) {
                            case "enemigo": {
                                ids.add(T.toInt(T.getPropertie(datosRectangulo, "idenemigo")));
                                maxs.add(T.toInt(T.getPropertie(datosRectangulo, "max")));
                                mins.add(T.toInt(T.getPropertie(datosRectangulo, "min")));
                                rs.add(rectangulo);
                                break;
                            }
                            case "puerta": {
                                String siguienteMapa = T.getPropertie(datosRectangulo, "mapa").toString();
                                int Xsalida = T.toInt(T.getPropertie(datosRectangulo, "x"));
                                int Ysalida = T.toInt(T.getPropertie(datosRectangulo, "y"));
                                Point salida = new Point(Xsalida, Ysalida);
                                this.puertas.add(new Puerta(rectangulo, siguienteMapa, salida));
                                break;
                            }
                            default: {
                                rectangulosCapa.add(rectangulo);
                            }
                        }
                        ++j;
                    }
                    this.capasColosiones.add(new CapaColosiones(anchoCapa, altoCapa, xCapa, yCapa, rectangulosCapa));
                }
            }
            ++i;
        }
        this.areasColisionOriginales = new ArrayList();
        i = 0;
        while (i < this.capasColosiones.size()) {
            ArrayList<Rectangle> rectangulos = this.capasColosiones.get((int)i).colisionables;
            int j = 0;
            while (j < rectangulos.size()) {
                this.areasColisionOriginales.add(rectangulos.get(j));
                ++j;
            }
            ++i;
        }
        int totalSprites = 0;
        int i2 = 0;
        while (i2 < coleccionesSprites.size()) {
            JSONObject datosGrupo = T.getObjetoJSON(coleccionesSprites.get(i2).toString());
            if (!datosGrupo.get("name").toString().equals("objetos")) {
                totalSprites += T.getIntJSON(datosGrupo, "tilecount");
            }
            ++i2;
        }
        this.paletaSprites = new Sprite[totalSprites];
        i2 = 0;
        while (i2 < coleccionesSprites.size()) {
            JSONObject datosGrupo = T.getObjetoJSON(coleccionesSprites.get(i2).toString());
            if (!datosGrupo.get("name").toString().equals("objetos")) {
                String nombreImagen = datosGrupo.get("image").toString();
                int anchoTile = T.getIntJSON(datosGrupo, "tilewidth");
                int altoTile = T.getIntJSON(datosGrupo, "tileheight");
                HojaSprites hojaSprite = nombreImagen.contains("/") ? new HojaSprites("imagenes/hojasTexturas/" + nombreImagen.substring(nombreImagen.lastIndexOf("/") + 1), anchoTile, altoTile, false) : new HojaSprites("imagenes/hojasTexturas/" + nombreImagen, anchoTile, altoTile, false);
                int primerSprite = T.getIntJSON(datosGrupo, "firstgid") - 1;
                int ultimoSprite = T.getIntJSON(datosGrupo, "tilecount") - 1;
                int j = 0;
                while (j < this.capasSprites.size()) {
                    CapaSprites capaActial = this.capasSprites.get(j);
                    int[] spritesCapa = capaActial.sprites;
                    int k = 0;
                    while (k < spritesCapa.length) {
                        int idSpriteActual = spritesCapa[k];
                        if (idSpriteActual >= primerSprite && idSpriteActual <= ultimoSprite && this.paletaSprites[idSpriteActual] == null) {
                            this.paletaSprites[idSpriteActual] = hojaSprite.getSprite(idSpriteActual - primerSprite);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int spritesUtilizados = 0;
        int i3 = 0;
        while (i3 < this.paletaSprites.length) {
            if (this.paletaSprites[i3] != null) {
                ++spritesUtilizados;
            }
            ++i3;
        }
        System.out.println(spritesUtilizados);
        System.out.println(this.objetosMapa.size());
        this.enemigosMapa = new ArrayList();
        if (T.getPropertie(info, "jefeid") != null) {
            int idEnemigo = T.toInt(T.getPropertie(info, "jefeid"));
            int xEnemigo = T.toInt(T.getPropertie(info, "jefeX"));
            int yEnemigo = T.toInt(T.getPropertie(info, "jefeY"));
            Point posicionEnemigo = new Point(xEnemigo * 32, yEnemigo * 32);
            Enemigo enemigo = RegistroEnemigos.getEnemigo(idEnemigo);
            enemigo.setPos(posicionEnemigo.x, posicionEnemigo.y);
            this.jefe = enemigo;
            this.tieneJefe = true;
        }
        if (T.getPropertie(info, "wintype") != null) {
            this.winCond = new WinCond(info);
        }
        if ((rutaMusica = T.getPropertie(info, "music")) != null) {
            SoundController.crearSonido(rutaMusica.toString(), this.nombre, -10.0f);
            this.tieneMusica = true;
        } else {
            SoundController.silence();
        }
        int i4 = 0;
        while (i4 < ids.size()) {
            this.generadores.add(new GeneradorEnemigos(this.areasColisionOriginales, (Rectangle)rs.get(i4), (Integer)maxs.get(i4), (Integer)mins.get(i4), (Integer)ids.get(i4), this.enemigosMapa));
            ++i4;
        }
        this.areasColisionActualizadas = new ArrayList();
    }

    public void actualizar() {
        if (this.tieneMusica) {
            SoundController.fadeInloop(this.nombre, 3.0f);
        }
        this.actualizarAreasColision();
        this.actualizarRecogidaObjetos();
        this.actualizarEnemigos();
        this.actualizarAtaques();
        this.actualizarPuertas();
        this.actualizarOpcionales();
        this.contadorActualizacion = this.contadorActualizacion >= 600 ? 0 : ++this.contadorActualizacion;
    }

    private void actualizarOpcionales() {
        if (this.winCond != null) {
            this.winCond.actualizar();
        }
    }

    private void actualizarPuertas() {
        for (Puerta puerta : this.puertas) {
            puerta.actualizar();
        }
    }

    private void actualizarAtaques() {
        Iterator<Enemigo> iterador = this.enemigosMapa.iterator();
        while (iterador.hasNext()) {
            Enemigo enemigo = iterador.next();
            if (!(enemigo.estado.HP < 1.0)) continue;
            for (Objeto objeto : enemigo.drops) {
                objeto.posMapa = new Point((int)T.getRandom(enemigo.posX - 96.0, enemigo.posX + 96.0), (int)T.getRandom(enemigo.posY - 96.0, enemigo.posY + 96.0));
                objeto.setEnMapa();
                this.objetosMapa.add(objeto);
            }
            iterador.remove();
        }
        if (this.jefe != null && this.jefe.estado.HP < 1.0) {
            for (Objeto objeto : this.jefe.drops) {
                objeto.posMapa = new Point((int)T.getRandom(this.jefe.posX - 96.0, this.jefe.posX + 96.0), (int)T.getRandom(this.jefe.posY - 96.0, this.jefe.posY + 96.0));
                objeto.setEnMapa();
                this.objetosMapa.add(objeto);
            }
            this.jefe = null;
        }
    }

    private void actualizarEnemigos() {
        if (!this.enemigosMapa.isEmpty()) {
            for (Enemigo enemigo : this.enemigosMapa) {
                enemigo.actualizar(this);
            }
        }
        if (!this.generadores.isEmpty()) {
            for (GeneradorEnemigos generador : this.generadores) {
                generador.actualizar();
            }
        }
        if (this.jefe != null) {
            this.jefe.actualizar(this);
        }
        int distX = 0;
        int distY = 0;
        if (!this.enemigosMapa.isEmpty()) {
            for (Enemigo enemigo : this.enemigosMapa) {
                if (!enemigo.jugadorDetectado) continue;
                if (Math.abs(enemigo.posX - ElementosPrincipales.jugador.posX) > (double)distX) {
                    distX = (int)Math.abs(enemigo.posX - ElementosPrincipales.jugador.posX);
                }
                if (!(Math.abs(enemigo.posY - ElementosPrincipales.jugador.posY) > (double)distY)) continue;
                distY = (int)Math.abs(enemigo.posY - ElementosPrincipales.jugador.posY);
            }
        }
        if (this.jefe != null && this.jefe.jugadorDetectado) {
            if (Math.abs(this.jefe.posX - ElementosPrincipales.jugador.posX) > (double)distX) {
                distX = (int)Math.abs(this.jefe.posX - ElementosPrincipales.jugador.posX) + 32;
            }
            if (Math.abs(this.jefe.posY - ElementosPrincipales.jugador.posY) > (double)distY) {
                distY = (int)Math.abs(this.jefe.posY - ElementosPrincipales.jugador.posY) + 32;
            }
        }
        if (distX > 320) {
            distX = 320;
        }
        if (distY > 320) {
            distY = 320;
        }
        Rectangle r = new Rectangle((int)ElementosPrincipales.jugador.posX - (distX + 32), (int)(ElementosPrincipales.jugador.posY - (double)(32 + distY)), distX * 2 + 64, distY * 2 + 64);
        if (!(this.contadorActualizacion % 90 != 0 || this.AreaDij != null && this.AreaDij.contains(r))) {
            this.AreaDij = r;
            this.d = new Dijkstra(ElementosPrincipales.jugador.getPosicionMapa(), r, this.areasColisionOriginales);
        }
        if (this.contadorActualizacion % 2 == 0) {
            this.d.reiniciarYEvaluar(ElementosPrincipales.jugador.getPosicionMapa());
        }
    }

    private void actualizarRecogidaObjetos() {
        if (!this.objetosMapa.isEmpty() && GestorControles.teclado.recogiendo) {
            Rectangle areaJugador = ElementosPrincipales.jugador.areaJugador;
            int i = 0;
            while (i < this.objetosMapa.size()) {
                Objeto objetoActual = this.objetosMapa.get(i);
                int puntoX = (int)((double)objetoActual.posMapa.x - ElementosPrincipales.jugador.posX + (double)Constantes.CENTRO_MARGEN_X);
                int puntoY = (int)((double)objetoActual.posMapa.y - ElementosPrincipales.jugador.posY + (double)Constantes.CENTRO_MARGEN_Y);
                Rectangle posicionObjetoActual = new Rectangle(puntoX, puntoY, 32, 32);
                if (areaJugador.intersects(posicionObjetoActual)) {
                    objetoActual.agarrar();
                    this.objetosMapa.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    private void actualizarAreasColision() {
        if (!this.areasColisionActualizadas.isEmpty()) {
            this.areasColisionActualizadas.clear();
        }
        int i = 0;
        while (i < this.areasColisionOriginales.size()) {
            Rectangle rInicial = this.areasColisionOriginales.get(i);
            if ((double)rInicial.x > ElementosPrincipales.jugador.posX && (double)rInicial.y > ElementosPrincipales.jugador.posY) {
                boolean bl = false;
            }
            int puntoX = rInicial.x - (int)ElementosPrincipales.jugador.posX + Constantes.CENTRO_MARGEN_X;
            int puntoY = rInicial.y - (int)ElementosPrincipales.jugador.posY + Constantes.CENTRO_MARGEN_Y;
            Rectangle rFinal = new Rectangle(puntoX, puntoY, rInicial.width, rInicial.height);
            if (rFinal.x + rFinal.width >= 0 && rFinal.x <= Constantes.ANCHO_JUEGO && rFinal.y + rFinal.height >= 0 && rFinal.y <= Constantes.ALTO_JUEGO) {
                this.areasColisionActualizadas.add(rFinal);
            }
            ++i;
        }
    }

    public void dibujar(Graphics g) {
        int i = 0;
        while (i < this.capasSprites.size()) {
            int[] spritesCapa = this.capasSprites.get((int)i).sprites;
            int y = 0;
            while (y < this.altoMapaTiles) {
                int x = 0;
                while (x < this.anchoMapaTiles) {
                    int idSpriteActual = spritesCapa[x + y * this.anchoMapaTiles];
                    if (idSpriteActual != -1) {
                        int puntoX = x * 32 - (int)ElementosPrincipales.jugador.posX + Constantes.CENTRO_MARGEN_X;
                        int puntoY = y * 32 - (int)ElementosPrincipales.jugador.posY + Constantes.CENTRO_MARGEN_Y;
                        if (puntoX + 32 >= 0 && puntoX <= Constantes.ANCHO_JUEGO && puntoY + 32 >= 0 && puntoY <= Constantes.ALTO_JUEGO) {
                            DibujoDebug.dibujarImagen(g, this.paletaSprites[idSpriteActual].getImagen(), puntoX, puntoY);
                        }
                    }
                    ++x;
                }
                ++y;
            }
            if (i == ElementosPrincipales.jugador.capaActual) {
                int j = 0;
                while (j < this.objetosMapa.size()) {
                    Objeto objetoActual = this.objetosMapa.get(j);
                    objetoActual.dibujar(g);
                    ++j;
                }
                for (Enemigo enemigo : this.enemigosMapa) {
                    int puntoX = (int)enemigo.posX - (int)ElementosPrincipales.jugador.posX + Constantes.CENTRO_MARGEN_X;
                    int puntoY = (int)enemigo.posY - (int)ElementosPrincipales.jugador.posY + Constantes.CENTRO_MARGEN_Y;
                    if (puntoX + 32 < 0 || puntoX > Constantes.ANCHO_JUEGO || puntoY + 32 < 0 || puntoY > Constantes.ALTO_JUEGO) continue;
                    enemigo.dibujar(g, puntoX, puntoY);
                }
                if (this.jefe != null) {
                    int puntoX = (int)this.jefe.posX - (int)ElementosPrincipales.jugador.posX + Constantes.CENTRO_MARGEN_X;
                    int puntoY = (int)this.jefe.posY - (int)ElementosPrincipales.jugador.posY + Constantes.CENTRO_MARGEN_Y;
                    if (puntoX + 32 >= 0 && puntoX <= Constantes.ANCHO_JUEGO && puntoY + 32 >= 0 && puntoY <= Constantes.ALTO_JUEGO) {
                        this.jefe.dibujar(g, puntoX, puntoY);
                    }
                }
                ElementosPrincipales.jugador.dibujar(g);
            }
            ++i;
        }
        if (GestorControles.teclado.debug) {
            if (this.d != null) {
                this.d.dibujar(g);
            }
            for (Rectangle r : this.areasColisionActualizadas) {
                DibujoDebug.dibujarRectangulo(g, r, Color.red);
            }
        }
    }

    public Rectangle getBordes(int posicionX, int posicionY) {
        int x = Constantes.CENTRO_MARGEN_X - posicionX + ElementosPrincipales.jugador.ancho;
        int y = Constantes.CENTRO_MARGEN_Y - posicionY + ElementosPrincipales.jugador.alto;
        int ancho = this.anchoMapaTiles * 32 - ElementosPrincipales.jugador.ancho * 2;
        int alto = this.altoMapaTiles * 32 - ElementosPrincipales.jugador.alto * 2;
        return new Rectangle(x, y, ancho, alto);
    }
}

