/*
 * Decompiled with CFR 0.152.
 */
package principal.interfaz_usuario;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.json.simple.JSONObject;
import principal.graficos.SuperficieDibujo;
import principal.herramientas.CargadorRecursos;
import principal.herramientas.DibujoDebug;
import principal.herramientas.T;
import principal.maquinaestado.estados.juego.GestorJuego;
import principal.maquinaestado.estados.menu.Boton;
import principal.maquinaestado.estados.menu.Menu;

public class MenuTutorial
extends Menu {
    public int maxPag;
    public int pag;
    public int cooldownPag = 0;
    public int maxCooldownPag = 15;
    public BufferedImage[] paginas;

    public MenuTutorial(SuperficieDibujo sd, JSONObject info) {
        super(sd, info);
        this.maxPag = T.getIntJSON(info, "paginas");
        this.pag = 0;
        this.paginas = new BufferedImage[this.maxPag];
        int i = 0;
        while (i < this.maxPag) {
            this.paginas[i] = CargadorRecursos.cargarImagenCompatibleOpaca("GUI/tutorial/" + (i + 1) + ".png");
            ++i;
        }
    }

    @Override
    public void actualizar() {
        super.actualizar();
        for (Boton boton : this.botonesMenu) {
            if (!boton.seleccionado || this.cooldownPag != 0 || !boton.tipo.equals("paginadorR")) continue;
            if (this.pag < this.maxPag - 1) {
                ++this.pag;
            } else {
                GestorJuego.gui.menuActual = -1;
            }
            this.cooldownPag = this.maxCooldownPag;
        }
        if (this.cooldownPag > 0) {
            --this.cooldownPag;
        }
    }

    @Override
    public void dibujar(Graphics g) {
        if (this.pag < this.maxPag) {
            DibujoDebug.dibujarImagen(g, this.paginas[this.pag], 0, 0);
        }
        super.dibujar(g);
    }
}

