/*
 * Decompiled with CFR 0.152.
 */
package principal.interfaz_usuario;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import org.json.simple.JSONObject;
import principal.ElementosPrincipales;
import principal.control.GestorControles;
import principal.elementos_jugador.Estado;
import principal.elementos_jugador.inventario.Toolbar;
import principal.graficos.SuperficieDibujo;
import principal.herramientas.CargadorRecursos;
import principal.herramientas.DibujoDebug;
import principal.herramientas.T;
import principal.interfaz_usuario.MenuTutorial;
import principal.maquinaestado.estados.menu.Menu;

public class GUI {
    public int xInicial;
    public int yInicial;
    public int ranuras;
    public int distancia;
    public int anchoBarras;
    public int altoBarras;
    public int yExp;
    public int yCal;
    public int yStm;
    public int yMP;
    public int yHP;
    public Color colorFondo;
    public Color colorSeleccionado;
    public Color colorCooldown;
    public Color colorExp;
    public Color colorCal;
    public Color colorStm;
    public Color colorMP;
    public Color colorHP;
    public Menu[] menus = new Menu[2];
    public SuperficieDibujo sd;
    public int menuActual = 1;

    public GUI(String ruta, SuperficieDibujo sd) {
        this.sd = sd;
        String infoString = CargadorRecursos.leerArchivoTexto(ruta);
        JSONObject info = T.getObjetoJSON(infoString);
        JSONObject infoBarraI = (JSONObject)info.get("barrainventario");
        this.xInicial = T.getIntJSON(infoBarraI, "x");
        this.yInicial = T.getIntJSON(infoBarraI, "y");
        this.ranuras = T.getIntJSON(infoBarraI, "ranuras");
        JSONObject colorfondoJSON = (JSONObject)infoBarraI.get("color");
        this.colorFondo = new Color(T.getIntJSON(colorfondoJSON, "r"), T.getIntJSON(colorfondoJSON, "g"), T.getIntJSON(colorfondoJSON, "b"), T.getIntJSON(colorfondoJSON, "a"));
        this.colorSeleccionado = new Color(T.getIntJSON(colorfondoJSON, "r"), T.getIntJSON(colorfondoJSON, "g"), T.getIntJSON(colorfondoJSON, "b"), T.getIntJSON(colorfondoJSON, "a") + 50);
        this.colorCooldown = new Color(T.getIntJSON(colorfondoJSON, "r") + 200, T.getIntJSON(colorfondoJSON, "g") + 200, T.getIntJSON(colorfondoJSON, "b") + 200, T.getIntJSON(colorfondoJSON, "a"));
        this.distancia = T.getIntJSON(infoBarraI, "distancia");
        this.anchoBarras = (32 + this.distancia) * this.ranuras - this.distancia;
        JSONObject infoBarras = (JSONObject)info.get("barras");
        this.altoBarras = T.getIntJSON(infoBarras, "alto");
        JSONObject colorExpJSON = (JSONObject)infoBarras.get("colorexp");
        this.colorExp = new Color(T.getIntJSON(colorExpJSON, "r"), T.getIntJSON(colorExpJSON, "g"), T.getIntJSON(colorExpJSON, "b"), T.getIntJSON(colorExpJSON, "a"));
        this.yExp = this.yInicial - this.altoBarras - this.distancia;
        this.yCal = this.yExp - this.altoBarras;
        this.yStm = this.yCal - this.altoBarras;
        this.yMP = this.yStm - this.altoBarras;
        this.yHP = this.yMP - this.altoBarras;
        JSONObject colorCalJSON = (JSONObject)infoBarras.get("colorcal");
        this.colorCal = new Color(T.getIntJSON(colorCalJSON, "r"), T.getIntJSON(colorCalJSON, "g"), T.getIntJSON(colorCalJSON, "b"), T.getIntJSON(colorCalJSON, "a"));
        JSONObject colorStmJSON = (JSONObject)infoBarras.get("colorstm");
        this.colorStm = new Color(T.getIntJSON(colorStmJSON, "r"), T.getIntJSON(colorStmJSON, "g"), T.getIntJSON(colorStmJSON, "b"), T.getIntJSON(colorStmJSON, "a"));
        JSONObject colorMPJSON = (JSONObject)infoBarras.get("colormp");
        this.colorMP = new Color(T.getIntJSON(colorMPJSON, "r"), T.getIntJSON(colorMPJSON, "g"), T.getIntJSON(colorMPJSON, "b"), T.getIntJSON(colorMPJSON, "a"));
        JSONObject colorHPJSON = (JSONObject)infoBarras.get("colorhp");
        this.colorHP = new Color(T.getIntJSON(colorHPJSON, "r"), T.getIntJSON(colorHPJSON, "g"), T.getIntJSON(colorHPJSON, "b"), T.getIntJSON(colorHPJSON, "a"));
        this.menus[0] = new Menu(sd, T.getObjetoJSON(T.getArrayJSON(info.get("menus").toString()).get(0).toString()));
        this.menus[1] = new MenuTutorial(sd, T.getObjetoJSON(T.getArrayJSON(info.get("menus").toString()).get(1).toString()));
    }

    public void actualizar() {
        if (this.menuActual != -1) {
            this.menus[this.menuActual].actualizar();
            if (GestorControles.teclado.atras) {
                this.menuActual = -1;
            }
        }
    }

    public void dibujar(Graphics g) {
        Estado estado = ElementosPrincipales.jugador.estado;
        g.setFont(g.getFont().deriveFont(8.0f));
        Toolbar tool = ElementosPrincipales.jugador.toolbar;
        int i = 0;
        while (i < this.ranuras) {
            if (i == tool.ranuraActual) {
                DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial + (32 + this.distancia) * i, this.yInicial, 32, 32, this.colorSeleccionado);
                int altoIndicadorCooldown = (int)(32.0 / estado.MaxcooldownAtaque * estado.cooldownAtaque);
                DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial + (32 + this.distancia) * i, this.yInicial, 32, altoIndicadorCooldown, this.colorCooldown);
            } else {
                DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial + (32 + this.distancia) * i, this.yInicial, 32, 32, this.colorFondo);
            }
            if (tool.elementos[i].id != 0) {
                Point posImg = new Point(this.xInicial + (32 + this.distancia) * i, this.yInicial);
                DibujoDebug.dibujarImagen(g, tool.elementos[i].getSprite().getImagen(), posImg);
                g.setFont(g.getFont().deriveFont(10.0f));
                DibujoDebug.dibujarRectanguloRelleno(g, posImg.x, posImg.y - T.MedirAltoPixeles(g, "" + tool.elementos[i].cantidad) + 32 + 2, T.MedirAnchoPixeles(g, "" + tool.elementos[i].cantidad), T.MedirAltoPixeles(g, "" + tool.elementos[i].cantidad) - 2, Color.black);
                DibujoDebug.dibujarString(g, "" + tool.elementos[i].cantidad, posImg.x, posImg.y + 32, Color.white);
                g.setFont(g.getFont().deriveFont(8.0f));
            }
            if (i != 9) {
                DibujoDebug.dibujarString(g, "" + (i + 1), this.xInicial + (32 + this.distancia) * i + (16 - T.MedirAnchoPixeles(g, "" + i) / 2), this.yInicial + 32 + this.distancia + 2, Color.white);
            } else {
                DibujoDebug.dibujarString(g, "0", this.xInicial + (32 + this.distancia) * i + (16 - T.MedirAnchoPixeles(g, "" + i) / 2), this.yInicial + 32 + this.distancia + 2, Color.white);
            }
            ++i;
        }
        DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial, this.yExp, this.anchoBarras, this.altoBarras, this.colorFondo);
        DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial, this.yExp, this.anchoBarras / estado.expMax * estado.exp, this.altoBarras, this.colorExp);
        int xTexto1 = this.xInicial - T.MedirAnchoPixeles(g, "EXP") - 2;
        DibujoDebug.dibujarString(g, "EXP", xTexto1, this.yExp + this.altoBarras, Color.white);
        DibujoDebug.dibujarString(g, String.valueOf(estado.exp) + "/" + estado.expMax, this.xInicial + this.anchoBarras + 2, this.yExp + this.altoBarras);
        DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial, this.yCal, this.anchoBarras, this.altoBarras, this.colorFondo);
        DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial, this.yCal, (int)((double)this.anchoBarras / estado.CalMax * estado.Cal), this.altoBarras, this.colorCal);
        DibujoDebug.dibujarString(g, "CAL", xTexto1, this.yCal + this.altoBarras, Color.white);
        DibujoDebug.dibujarString(g, String.valueOf((int)(estado.Cal / 200.0)) + "/" + (int)(estado.CalMax / 200.0), this.xInicial + this.anchoBarras + 2, this.yCal + this.altoBarras);
        DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial, this.yStm, this.anchoBarras, this.altoBarras, this.colorFondo);
        DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial, this.yStm, (int)((double)this.anchoBarras / estado.StmMax * estado.Stm), this.altoBarras, this.colorStm);
        DibujoDebug.dibujarString(g, "STM", xTexto1, this.yStm + this.altoBarras, Color.white);
        DibujoDebug.dibujarString(g, String.valueOf((int)(estado.Stm / 10.0)) + "/" + (int)(estado.StmMax / 10.0), this.xInicial + this.anchoBarras + 2, this.yStm + this.altoBarras);
        DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial, this.yMP, this.anchoBarras, this.altoBarras, this.colorFondo);
        DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial, this.yMP, (int)((double)this.anchoBarras / estado.MPMax * estado.MP), this.altoBarras, this.colorMP);
        DibujoDebug.dibujarString(g, "MP", xTexto1, this.yMP + this.altoBarras, Color.white);
        DibujoDebug.dibujarString(g, String.valueOf((int)estado.MP) + "/" + (int)estado.MPMax, this.xInicial + this.anchoBarras + 2, this.yMP + this.altoBarras);
        DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial, this.yHP, this.anchoBarras, this.altoBarras, this.colorFondo);
        DibujoDebug.dibujarRectanguloRelleno(g, this.xInicial, this.yHP, (int)((double)this.anchoBarras / estado.HPMax * estado.HP), this.altoBarras, this.colorHP);
        DibujoDebug.dibujarString(g, "HP", xTexto1, this.yHP + this.altoBarras, Color.white);
        DibujoDebug.dibujarString(g, String.valueOf((int)estado.HP) + "/" + (int)estado.HPMax, this.xInicial + this.anchoBarras + 2, this.yHP + this.altoBarras);
        g.setFont(g.getFont().deriveFont(12.0f));
        if (this.menuActual != -1) {
            this.menus[this.menuActual].dibujar(g);
        }
    }
}

