/*
 * Decompiled with CFR 0.152.
 */
package principal.herramientas;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import principal.Constantes;
import principal.graficos.SuperficieDibujo;
import principal.herramientas.DibujoDebug;

public class T {
    public static double getRandom(int min, int max) {
        return Math.random() * (double)(max - min) + (double)min;
    }

    public static double getDistanciaEntrePuntos(Point p1, Point p2) {
        return Math.sqrt(Math.pow(p2.getX() - p1.getX(), 2.0) + Math.pow(p2.getY() - p1.getY(), 2.0));
    }

    public static Rectangle escalarRectanguloArriba(Rectangle r) {
        return new Rectangle((int)((double)r.x * Constantes.FACTOR_ESCALADO_X), (int)((double)r.y * Constantes.FACTOR_ESCALADO_Y), (int)((double)r.width * Constantes.FACTOR_ESCALADO_X), (int)((double)r.height * Constantes.FACTOR_ESCALADO_Y));
    }

    public static Point escalarPuntoArriba(Point p) {
        return new Point((int)((double)p.x * Constantes.FACTOR_ESCALADO_X), (int)((double)p.y * Constantes.FACTOR_ESCALADO_Y));
    }

    public static Rectangle escalarRectanguloAbajo(Rectangle r) {
        return new Rectangle((int)((double)r.x / Constantes.FACTOR_ESCALADO_X), (int)((double)r.y / Constantes.FACTOR_ESCALADO_Y), (int)((double)r.width / Constantes.FACTOR_ESCALADO_X), (int)((double)r.height / Constantes.FACTOR_ESCALADO_Y));
    }

    public static Point escalarPuntoAbajo(Point p) {
        return new Point((int)((double)p.x / Constantes.FACTOR_ESCALADO_X), (int)((double)p.y / Constantes.FACTOR_ESCALADO_Y));
    }

    public static void dibujarTooltip(Graphics g, SuperficieDibujo sd, String texto) {
        Point posicionRaton = T.escalarPuntoAbajo(sd.raton.posicion);
        Point centroCanvas = new Point(Constantes.CENTRO_VENTANA_X, Constantes.CENTRO_VENTANA_Y);
        String pistaPosicion = posicionRaton.x <= centroCanvas.x ? (posicionRaton.y <= centroCanvas.y ? "no" : "so") : (posicionRaton.y <= centroCanvas.y ? "ne" : "se");
        int ancho = T.MedirAnchoPixeles(g, texto);
        int alto = T.MedirAltoPixeles(g, texto);
        int margenFuente = 2;
        Rectangle tooltip = null;
        switch (pistaPosicion) {
            case "no": {
                tooltip = new Rectangle(posicionRaton.x, posicionRaton.y, ancho + 4, alto);
                break;
            }
            case "ne": {
                tooltip = new Rectangle(posicionRaton.x - ancho, posicionRaton.y, ancho + 4, alto);
                break;
            }
            case "so": {
                tooltip = new Rectangle(posicionRaton.x, posicionRaton.y - alto, ancho + 4, alto);
                break;
            }
            case "se": {
                tooltip = new Rectangle(posicionRaton.x - ancho, posicionRaton.y - alto, ancho + 4, alto);
            }
        }
        DibujoDebug.dibujarRectanguloRelleno(g, tooltip, Color.black);
        DibujoDebug.dibujarString(g, texto, tooltip.x + 2, tooltip.y + tooltip.height - 2, Color.white);
    }

    public static int MedirAnchoPixeles(Graphics g, String s) {
        FontMetrics fm = g.getFontMetrics();
        return fm.stringWidth(s);
    }

    public static int MedirAltoPixeles(Graphics g, String s) {
        FontMetrics fm = g.getFontMetrics();
        return (int)fm.getLineMetrics(s, g).getHeight();
    }

    public static JSONObject getObjetoJSON(String codigoJSON) {
        JSONParser lector = new JSONParser();
        JSONObject objetoJSON = null;
        try {
            Object recuperado = lector.parse(codigoJSON);
            objetoJSON = (JSONObject)recuperado;
        }
        catch (ParseException e) {
            System.out.println("Posicion:" + e.getPosition());
            System.out.println(e);
            System.exit(0);
        }
        return objetoJSON;
    }

    public static JSONArray getArrayJSON(String codigoJSON) {
        JSONParser lector = new JSONParser();
        JSONArray arrayJSON = null;
        try {
            Object recuperado = lector.parse(codigoJSON);
            arrayJSON = (JSONArray)recuperado;
        }
        catch (ParseException e) {
            System.out.println("Posicion:" + e.getPosition());
            System.out.println(e);
            System.exit(0);
        }
        return arrayJSON;
    }

    public static int getIntJSON(JSONObject objetoJSON, String clave) {
        if (!objetoJSON.get(clave).toString().contains(".")) {
            return Integer.parseInt(objetoJSON.get(clave).toString());
        }
        return (int)Double.parseDouble(objetoJSON.get(clave).toString());
    }

    public static double getDoubJSON(JSONObject objetoJSON, String clave) {
        if (!objetoJSON.get(clave).toString().contains(".")) {
            return Integer.parseInt(objetoJSON.get(clave).toString());
        }
        return Double.parseDouble(objetoJSON.get(clave).toString());
    }

    public static Object getPropertie(JSONObject info, String nombre) {
        Object objeto = null;
        JSONArray properties = T.getArrayJSON(info.get("properties").toString());
        if (properties == null) {
            return null;
        }
        int i = 0;
        while (i < properties.size()) {
            block18: {
                JSONObject property = T.getObjetoJSON(properties.get(i).toString());
                if (!property.get("name").toString().equals(nombre)) break block18;
                switch (property.get("type").toString()) {
                    case "int": {
                        objeto = T.getIntJSON(property, "value");
                        break;
                    }
                    case "bool": {
                        objeto = Boolean.parseBoolean(property.get("value").toString());
                        break;
                    }
                    case "float": {
                        objeto = T.getDoubJSON(property, "value");
                        break;
                    }
                    case "string": {
                        objeto = property.get("value").toString();
                        break;
                    }
                    default: {
                        objeto = null;
                        break;
                    }
                }
                break;
            }
            ++i;
        }
        return objeto;
    }

    public static int toInt(Object obj) {
        int i = 0;
        if (obj != null) {
            try {
                i = Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException e) {
                i = 0;
            }
        }
        return i;
    }

    public static boolean toBool(Object obj) {
        return Boolean.parseBoolean(obj.toString());
    }

    public static double toDoub(Object obj) {
        double i = 0.0;
        if (obj != null) {
            try {
                try {
                    i = Double.parseDouble(obj.toString());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    i = 0.0;
                }
            }
            finally {
                i = 0.0;
            }
        }
        return i;
    }

    public static double getRandom(double min, double max) {
        return Math.random() * (max - min) + min;
    }

    public static double limitarDecimales(double d, double distanciaPunto) {
        return (d * Math.pow(10.0, distanciaPunto) - d * Math.pow(10.0, distanciaPunto) % 1.0) / Math.pow(10.0, distanciaPunto);
    }
}

