/*
 * Decompiled with CFR 0.152.
 */
package principal.herramientas;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import principal.Constantes;
import principal.graficos.SuperficieDibujo;
import principal.herramientas.DibujoDebug;
import principal.herramientas.EscaladorElementos;
import principal.herramientas.MedidorString;

public class GeneradorTooltip {
    private static Point generarTooltip(Point pi) {
        int x = pi.x;
        int y = pi.y;
        Point centroCanvas = EscaladorElementos.escalarPuntoArriba(new Point(Constantes.CENTRO_VENTANA_X, Constantes.CENTRO_VENTANA_Y));
        int margenCursor = 5;
        Point pf = new Point();
        if (x <= centroCanvas.x) {
            if (y <= centroCanvas.y) {
                pf.x = x + Constantes.LADO_CURSOR + 5;
                pf.y = y + Constantes.LADO_CURSOR + 5;
            } else {
                pf.x = x + Constantes.LADO_CURSOR + 5;
                pf.y = y - Constantes.LADO_CURSOR - 5;
            }
        } else if (y <= centroCanvas.y) {
            pf.x = x - Constantes.LADO_CURSOR - 5;
            pf.y = y + Constantes.LADO_CURSOR + 5;
        } else {
            pf.x = x - Constantes.LADO_CURSOR - 5;
            pf.y = y - Constantes.LADO_CURSOR - 5;
        }
        return pf;
    }

    private static String getPosicionTooltip(Point p) {
        Point centroCanvas = EscaladorElementos.escalarPuntoArriba(new Point(Constantes.CENTRO_VENTANA_X, Constantes.CENTRO_VENTANA_Y));
        String posicion = "";
        posicion = p.x <= centroCanvas.x ? (p.y <= centroCanvas.y ? "no" : "so") : (p.y <= centroCanvas.y ? "ne" : "se");
        return posicion;
    }

    public static void dibujarTooltip(Graphics g, SuperficieDibujo sd, String texto) {
        Point posicionRaton = sd.raton.posicion;
        Point posicionTooltip = EscaladorElementos.escalarPuntoAbajo(GeneradorTooltip.generarTooltip(posicionRaton));
        String pistaPosicion = GeneradorTooltip.getPosicionTooltip(posicionRaton);
        int ancho = MedidorString.MedirAnchoPixeles(g, texto);
        int alto = MedidorString.MedirAltoPixeles(g, texto);
        int margenFuente = 2;
        Rectangle tooltip = null;
        switch (pistaPosicion) {
            case "no": {
                tooltip = new Rectangle(posicionTooltip.x, posicionTooltip.y, ancho + 4, alto);
                break;
            }
            case "ne": {
                tooltip = new Rectangle(posicionTooltip.x - ancho, posicionTooltip.y, ancho + 4, alto);
                break;
            }
            case "so": {
                tooltip = new Rectangle(posicionTooltip.x, posicionTooltip.y - alto, ancho + 4, alto);
                break;
            }
            case "se": {
                tooltip = new Rectangle(posicionTooltip.x - ancho, posicionTooltip.y - alto, ancho + 4, alto);
            }
        }
        DibujoDebug.dibujarRectanguloRelleno(g, tooltip, Color.black);
        DibujoDebug.dibujarString(g, texto, tooltip.x + 2, tooltip.y + tooltip.height - 2, Color.white);
    }
}

