/*
 * Decompiled with CFR 0.152.
 */
package principal.herramientas;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import org.json.simple.JSONObject;

public class CargadorRecursosExternos {
    public void guardarJSON(JSONObject obj, String rutaRelativa) {
        String data = obj.toString();
        try {
            FileOutputStream out = new FileOutputStream(rutaRelativa);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
            bw.write(data);
            bw.flush();
            bw.close();
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public static BufferedImage cargarImagenCompatibleOpaca(String ruta) {
        BufferedImage imagen = null;
        try {
            FileInputStream input = new FileInputStream(ruta);
            imagen = ImageIO.read(input);
            ((InputStream)input).close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage imagenAcelerada = gc.createCompatibleImage(((Image)imagen).getWidth(null), ((Image)imagen).getHeight(null), 3);
        Graphics g = imagenAcelerada.getGraphics();
        g.drawImage(imagen, 0, 0, null);
        g.dispose();
        return imagenAcelerada;
    }

    public static BufferedImage cargarImagenCompatibleTranslucida(String ruta) {
        BufferedImage imagen = null;
        try {
            FileInputStream input = new FileInputStream(ruta);
            imagen = ImageIO.read(input);
            ((InputStream)input).close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage imagenAcelerada = gc.createCompatibleImage(((Image)imagen).getWidth(null), ((Image)imagen).getHeight(null), 3);
        Graphics g = imagenAcelerada.getGraphics();
        g.drawImage(imagen, 0, 0, null);
        g.dispose();
        return imagenAcelerada;
    }

    public static String leerArchivoTexto(String ruta) {
        String contenido = "";
        try {
            String linea;
            FileInputStream input = new FileInputStream(ruta);
            BufferedReader lector = new BufferedReader(new InputStreamReader(input));
            while ((linea = lector.readLine()) != null) {
                contenido = String.valueOf(contenido) + linea;
            }
            ((InputStream)input).close();
            lector.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        return contenido;
    }

    public static Font cargarFuente(String ruta) {
        Font fuente = null;
        try {
            FileInputStream input = new FileInputStream(ruta);
            fuente = Font.createFont(0, input);
            ((InputStream)input).close();
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        fuente = fuente.deriveFont(12.0f);
        return fuente;
    }

    public static Clip cargarSonido(String ruta) {
        Clip clip = null;
        try {
            FileInputStream input = new FileInputStream(ruta);
            AudioInputStream ais = AudioSystem.getAudioInputStream(new BufferedInputStream(input));
            DataLine.Info info = new DataLine.Info(Clip.class, ais.getFormat());
            clip = (Clip)AudioSystem.getLine(info);
            clip.open(ais);
            ((InputStream)input).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return clip;
    }
}

