/*
 * Decompiled with CFR 0.152.
 */
package principal.herramientas;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;

public class CargadorRecursos {
    public static BufferedImage cargarImagenCompatibleOpaca(String ruta) {
        Image imagen = null;
        try {
            InputStream input = CargadorRecursos.class.getResourceAsStream("/recursos/" + ruta);
            if (input == null) {
                input = CargadorRecursos.class.getClassLoader().getResourceAsStream(ruta);
            }
            imagen = ImageIO.read(input);
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage imagenAcelerada = gc.createCompatibleImage(imagen.getWidth(null), imagen.getHeight(null), 3);
        Graphics g = imagenAcelerada.getGraphics();
        g.drawImage(imagen, 0, 0, null);
        g.dispose();
        return imagenAcelerada;
    }

    public static BufferedImage cargarImagenCompatibleTranslucida(String ruta) {
        Image imagen = null;
        try {
            InputStream input = CargadorRecursos.class.getResourceAsStream("/recursos/" + ruta);
            if (input == null) {
                input = CargadorRecursos.class.getClassLoader().getResourceAsStream(ruta);
            }
            imagen = ImageIO.read(input);
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage imagenAcelerada = gc.createCompatibleImage(imagen.getWidth(null), imagen.getHeight(null), 3);
        Graphics g = imagenAcelerada.getGraphics();
        g.drawImage(imagen, 0, 0, null);
        g.dispose();
        return imagenAcelerada;
    }

    public static String leerArchivoTexto(String ruta) {
        String contenido = "";
        InputStream input = CargadorRecursos.class.getResourceAsStream("/recursos/" + ruta);
        if (input == null) {
            input = CargadorRecursos.class.getClassLoader().getResourceAsStream(ruta);
        }
        try {
            try {
                byte[] bytes = input.readAllBytes();
                contenido = new String(bytes, 0, bytes.length, Charset.defaultCharset());
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.exit(0);
                }
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.exit(0);
            }
        }
        return contenido;
    }

    public static Font cargarFuente(String ruta) {
        Font fuente = null;
        InputStream input = CargadorRecursos.class.getResourceAsStream("/recursos/" + ruta);
        if (input == null) {
            input = CargadorRecursos.class.getClassLoader().getResourceAsStream(ruta);
        }
        try {
            fuente = Font.createFont(0, input);
            input.close();
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        fuente = fuente.deriveFont(12.0f);
        return fuente;
    }

    public static Clip cargarSonido(String ruta) {
        Clip clip = null;
        InputStream input = CargadorRecursos.class.getResourceAsStream("/recursos/" + ruta);
        if (input == null) {
            input = CargadorRecursos.class.getClassLoader().getResourceAsStream(ruta);
        }
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new BufferedInputStream(input));
            DataLine.Info info = new DataLine.Info(Clip.class, ais.getFormat());
            clip = (Clip)AudioSystem.getLine(info);
            clip.open(ais);
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return clip;
    }
}

