/*
 * Decompiled with CFR 0.152.
 */
package principal.graficos;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import principal.Constantes;
import principal.GestorPrincipal;
import principal.control.GestorControles;
import principal.control.Raton;
import principal.herramientas.DatosDebug;
import principal.herramientas.DibujoDebug;
import principal.maquinaestado.GestorEstados;

public class SuperficieDibujo
extends Canvas {
    private static final long serialVersionUID = -6227038142688953660L;
    public Raton raton = new Raton(this);

    public SuperficieDibujo(int ancho, int alto) {
        this.setIgnoreRepaint(true);
        this.setCursor(this.raton.cursor);
        this.setPreferredSize(new Dimension(ancho, alto));
        this.addKeyListener(GestorControles.teclado);
        this.addMouseListener(this.raton);
        this.setFocusable(true);
        this.requestFocus();
    }

    public void dibujar(GestorEstados ge) {
        BufferStrategy buffer = this.getBufferStrategy();
        if (buffer == null) {
            this.createBufferStrategy(2);
            return;
        }
        Graphics2D g = (Graphics2D)buffer.getDrawGraphics();
        g.setFont(Constantes.fuentePixel);
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, Constantes.ANCHO_PANTALLA_COMPLETA, Constantes.ALTO_PANTALLA_COMPLETA);
        if (Constantes.FACTOR_ESCALADO_X != 1.0 || Constantes.FACTOR_ESCALADO_Y != 1.0) {
            g.scale(Constantes.FACTOR_ESCALADO_X, Constantes.FACTOR_ESCALADO_Y);
        }
        ge.dibujar(g);
        DatosDebug.enviarDato("Escala: X:" + Constantes.FACTOR_ESCALADO_X + " , Y:" + Constantes.FACTOR_ESCALADO_Y);
        g.setColor(Color.white);
        g.drawString("APS: " + GestorPrincipal.aps, 20, 20);
        g.drawString("FPS: " + GestorPrincipal.fps, 20, 30);
        this.raton.dibujar(g);
        DatosDebug.enviarDato("OPF: " + DibujoDebug.getObjetosDibujados());
        if (GestorControles.teclado.debug) {
            DatosDebug.dibujarDatos(g);
        } else {
            DatosDebug.vaciarDatos();
        }
        DibujoDebug.reiniciarContador();
        Toolkit.getDefaultToolkit().sync();
        g.dispose();
        buffer.show();
    }

    public void actualizar() {
        this.raton.actualizar(this);
    }
}

