/*
 * Decompiled with CFR 0.152.
 */
package principal.entes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import principal.Constantes;
import principal.ElementosPrincipales;
import principal.control.GestorControles;
import principal.elementos_jugador.Estado;
import principal.elementos_jugador.Inventario;
import principal.elementos_jugador.inventario.Toolbar;
import principal.herramientas.DatosDebug;
import principal.herramientas.DibujoDebug;
import principal.sprites.HojaSprites;

public class Jugador {
    public double posX;
    public double posY;
    public int direccion;
    private double vel = 2.0;
    private boolean enMovimiento;
    private HojaSprites hs;
    private BufferedImage imagenActual;
    public final int ancho = 15;
    public final int alto = 7;
    private final int Xoffset = 7;
    private final int Yoffset = 24;
    private final int centroX = Constantes.CENTRO_VENTANA_X - Constantes.CENTRO_SPRITE;
    private final int centroY = Constantes.CENTRO_VENTANA_Y - Constantes.CENTRO_SPRITE;
    private final Rectangle LIMITE_ARRIBA = new Rectangle(this.centroX + 7, this.centroY + 24, 15, 1);
    private final Rectangle LIMITE_ABAJO = new Rectangle(this.centroX + 7, this.centroY + 24 + 7, 15, 1);
    private final Rectangle LIMITE_IZQUIERDO = new Rectangle(this.centroX + 7, this.centroY + 24, 1, 7);
    private final Rectangle LIMITE_DERECHO = new Rectangle(this.centroX + 7 + 15, this.centroY + 24, 1, 7);
    public final Rectangle areaJugador = new Rectangle(this.centroX, this.centroY, 32, 32);
    private int actualizaciones;
    private int animacion;
    public Inventario inventario = new Inventario();
    public static final int RESISTENCIA_TOTAL = 600;
    public int resistencia = 600;
    public int capaActual;
    public int limitePeso = 200;
    public int pesoActual = 30;
    public ArrayList<Rectangle> alcanceActual;
    public Estado estado;
    public Toolbar toolbar;

    private void cambiarDireccion(int velX, int velY) {
        if (velX == -1) {
            this.direccion = 3;
        } else if (velX == 1) {
            this.direccion = 2;
        }
        if (velY == -1) {
            this.direccion = 1;
        } else if (velY == 1) {
            this.direccion = 0;
        }
    }

    public Jugador() {
        this.posX = ElementosPrincipales.mapa.puntoInicial.getX();
        this.posY = ElementosPrincipales.mapa.puntoInicial.getY();
        this.capaActual = ElementosPrincipales.mapa.capaInicial;
        this.actualizaciones = 0;
        this.direccion = 0;
        this.enMovimiento = false;
        this.hs = new HojaSprites(Constantes.RUTA_HOJA_SPRITES_JUGADOR, 32, false);
        this.imagenActual = this.hs.getSprite(0).getImagen();
        this.animacion = 0;
        this.alcanceActual = new ArrayList();
        this.estado = new Estado("jugador/estado.json", true);
        this.inventario = new Inventario();
        this.toolbar = new Toolbar();
    }

    public void actualizar() {
        if (GestorControles.teclado.shift && this.estado.Stm > 0.0) {
            this.vel = this.estado.agilidad * 2 / 5;
            this.estado.recuperandoStm = false;
        } else {
            this.vel = ((double)this.estado.agilidad / (double)this.estado.strenght * 10.0 - (double)this.estado.agilidad / (double)this.estado.strenght * 10.0 % 1.0) / 10.0;
            this.estado.recuperandoStm = true;
        }
        if ((int)((double)this.actualizaciones % (12.0 / this.vel)) == 0) {
            ++this.animacion;
            if (this.animacion >= 4) {
                this.animacion = 0;
            }
        }
        this.enMovimiento = false;
        int velocidadX = this.evaluarVelX();
        int velocidadY = this.evaluarVelY();
        if (velocidadY != 0 || velocidadX != 0) {
            if (velocidadX != 0 && velocidadY == 0 || velocidadX == 0 && velocidadY != 0) {
                this.mover(velocidadX, velocidadY);
            } else {
                if (velocidadX == -1 && velocidadY == -1) {
                    if (GestorControles.teclado.izquierda.ultimaPulsacion > GestorControles.teclado.arriba.ultimaPulsacion) {
                        this.mover(velocidadX, 0);
                    } else {
                        this.mover(0, velocidadY);
                    }
                }
                if (velocidadX == -1 && velocidadY == 1) {
                    if (GestorControles.teclado.izquierda.ultimaPulsacion > GestorControles.teclado.abajo.ultimaPulsacion) {
                        this.mover(velocidadX, 0);
                    } else {
                        this.mover(0, velocidadY);
                    }
                }
                if (velocidadX == 1 && velocidadY == -1) {
                    if (GestorControles.teclado.derecha.ultimaPulsacion > GestorControles.teclado.arriba.ultimaPulsacion) {
                        this.mover(velocidadX, 0);
                    } else {
                        this.mover(0, velocidadY);
                    }
                }
                if (velocidadX == 1 && velocidadY == 1) {
                    if (GestorControles.teclado.derecha.ultimaPulsacion > GestorControles.teclado.abajo.ultimaPulsacion) {
                        this.mover(velocidadX, 0);
                    } else {
                        this.mover(0, velocidadY);
                    }
                }
            }
        }
        if (!this.enMovimiento) {
            this.animacion = 0;
            this.actualizaciones = 0;
        }
        this.imagenActual = this.hs.getSprite(this.direccion, this.animacion).getImagen();
        this.estado.actualizar();
        this.toolbar.actualizar();
        this.actualizaciones = this.actualizaciones < 600 ? ++this.actualizaciones : 0;
    }

    private void mover(int velX, int velY) {
        this.enMovimiento = true;
        this.cambiarDireccion(velX, velY);
        if (!this.fueraMapa(velX, velY)) {
            if (velX == -1 && !this.enColisionIzquierda(velX)) {
                this.posX += (double)velX * this.vel;
                if (GestorControles.teclado.shift && this.estado.Stm > 0.0) {
                    this.estado.Stm -= (double)this.estado.agilidad / 60.0 * 2.5;
                }
            }
            if (velX == 1 && !this.enColisionDerecha(velX)) {
                this.posX += (double)velX * this.vel;
                if (GestorControles.teclado.shift && this.estado.Stm > 0.0) {
                    this.estado.Stm -= (double)this.estado.agilidad / 60.0 * 2.5;
                }
            }
            if (velY == -1 && !this.enColisionArriba(velY)) {
                this.posY += (double)velY * this.vel;
                if (GestorControles.teclado.shift && this.estado.Stm > 0.0) {
                    this.estado.Stm -= (double)this.estado.agilidad / 60.0 * 2.5;
                }
            }
            if (velY == 1 && !this.enColisionAbajo(velY)) {
                this.posY += (double)velY * this.vel;
                if (GestorControles.teclado.shift && this.estado.Stm > 0.0) {
                    this.estado.Stm -= (double)this.estado.agilidad / 60.0 * 2.5;
                }
            }
        }
        this.posX = (this.posX * 10.0 - this.posX * 10.0 % 1.0) / 10.0;
        this.posY = (this.posY * 10.0 - this.posY * 10.0 % 1.0) / 10.0;
    }

    private boolean enColisionArriba(int velY) {
        int r = 0;
        while (r < ElementosPrincipales.mapa.areasColisionActualizadas.size()) {
            Rectangle area = ElementosPrincipales.mapa.areasColisionActualizadas.get(r);
            int origenX = area.x;
            int origenY = area.y + velY * (int)this.vel + 3 * (int)this.vel;
            Rectangle areaFutura = new Rectangle(origenX, origenY, area.width, area.height);
            if (this.LIMITE_ARRIBA.intersects(areaFutura)) {
                return true;
            }
            ++r;
        }
        return false;
    }

    private boolean enColisionAbajo(int velY) {
        int r = 0;
        while (r < ElementosPrincipales.mapa.areasColisionActualizadas.size()) {
            Rectangle area = ElementosPrincipales.mapa.areasColisionActualizadas.get(r);
            int origenX = area.x;
            int origenY = area.y + velY * (int)this.vel - 3 * (int)this.vel;
            Rectangle areaFutura = new Rectangle(origenX, origenY, area.width, area.height);
            if (this.LIMITE_ABAJO.intersects(areaFutura)) {
                return true;
            }
            ++r;
        }
        return false;
    }

    private boolean enColisionIzquierda(int velX) {
        int r = 0;
        while (r < ElementosPrincipales.mapa.areasColisionActualizadas.size()) {
            Rectangle area = ElementosPrincipales.mapa.areasColisionActualizadas.get(r);
            int origenX = area.x + velX * (int)this.vel + 3 * (int)this.vel;
            int origenY = area.y;
            Rectangle areaFutura = new Rectangle(origenX, origenY, area.width, area.height);
            if (this.LIMITE_IZQUIERDO.intersects(areaFutura)) {
                return true;
            }
            ++r;
        }
        return false;
    }

    private boolean enColisionDerecha(int velX) {
        int r = 0;
        while (r < ElementosPrincipales.mapa.areasColisionActualizadas.size()) {
            Rectangle area = ElementosPrincipales.mapa.areasColisionActualizadas.get(r);
            int origenX = area.x + velX * (int)this.vel - 3 * (int)this.vel;
            int origenY = area.y;
            Rectangle areaFutura = new Rectangle(origenX, origenY, area.width, area.height);
            if (this.LIMITE_DERECHO.intersects(areaFutura)) {
                return true;
            }
            ++r;
        }
        return false;
    }

    private boolean fueraMapa(int velX, int velY) {
        int posicionFuturaX = (int)this.posX + velX * (int)this.vel;
        int posicionFuturaY = (int)this.posY + velY * (int)this.vel;
        Rectangle bordesMapa = ElementosPrincipales.mapa.getBordes(posicionFuturaX, posicionFuturaY);
        boolean fuera = !this.LIMITE_ARRIBA.intersects(bordesMapa) && !this.LIMITE_ABAJO.intersects(bordesMapa) && !this.LIMITE_IZQUIERDO.intersects(bordesMapa) && !this.LIMITE_DERECHO.intersects(bordesMapa);
        return fuera;
    }

    private int evaluarVelX() {
        int velX = 0;
        if (GestorControles.teclado.izquierda.pulsada && !GestorControles.teclado.derecha.pulsada) {
            velX = -1;
        } else if (GestorControles.teclado.derecha.pulsada && !GestorControles.teclado.izquierda.pulsada) {
            velX = 1;
        }
        return velX;
    }

    private int evaluarVelY() {
        int velY = 0;
        if (GestorControles.teclado.arriba.pulsada && !GestorControles.teclado.abajo.pulsada) {
            velY = -1;
        } else if (GestorControles.teclado.abajo.pulsada && !GestorControles.teclado.arriba.pulsada) {
            velY = 1;
        }
        return velY;
    }

    public void dibujar(Graphics g) {
        if (GestorControles.teclado.debug) {
            DibujoDebug.dibujarImagen(g, this.imagenActual, this.centroX, this.centroY);
            if (!this.alcanceActual.isEmpty()) {
                for (Rectangle r : this.alcanceActual) {
                    DibujoDebug.dibujarRectangulo(g, r, Color.green);
                }
            }
            DatosDebug.enviarDato("Resistencia: " + this.resistencia);
        } else {
            g.drawImage(this.imagenActual, this.centroX, this.centroY, null);
        }
    }

    public Point getPosicionMapa() {
        int px = (int)this.posX / 32;
        int py = (int)this.posY / 32;
        return new Point(px, py);
    }

    public Point getPosicion() {
        return new Point((int)this.posX, (int)this.posY);
    }
}

