/*
 * Decompiled with CFR 0.152.
 */
package principal.entes;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import principal.entes.Enemigo;
import principal.herramientas.T;

public class GeneradorEnemigos {
    public ArrayList<Point> puntos;
    public ArrayList<Rectangle> colisiones;
    public final ArrayList<Enemigo> enemigos;
    Rectangle area;
    int maxEnemigos;
    int minEnemigos;
    int id;

    public GeneradorEnemigos(ArrayList<Rectangle> colisiones, Rectangle areaO, int maxEnemigos, int minEnemigos, int id, ArrayList<Enemigo> enemigos) {
        this.enemigos = enemigos;
        this.area = new Rectangle(areaO.x / 32, areaO.y / 32, areaO.width / 32, areaO.height / 32);
        this.maxEnemigos = maxEnemigos;
        this.minEnemigos = minEnemigos;
        this.id = id;
        this.colisiones = colisiones;
        this.puntos = new ArrayList();
        int y = 0;
        while (y < this.area.height) {
            int x = 0;
            while (x < this.area.width) {
                boolean disponible = true;
                for (Rectangle c : colisiones) {
                    if (!c.intersects(new Rectangle((x + this.area.x) * 32, (y + this.area.y) * 32, 32, 32))) continue;
                    disponible = false;
                    break;
                }
                if (disponible) {
                    this.puntos.add(new Point(x + this.area.x, y + this.area.y));
                } else {
                    this.puntos.add(null);
                }
                ++x;
            }
            ++y;
        }
        int enemigosActuales = 0;
        for (Enemigo enemigo : enemigos) {
            if (enemigo.id != id || !this.area.intersects(new Rectangle((int)(enemigo.posX / 32.0), (int)(enemigo.posY / 32.0), 1, 1))) continue;
            ++enemigosActuales;
        }
        if (enemigosActuales < minEnemigos) {
            int i = enemigosActuales;
            while (i < maxEnemigos) {
                int r = (int)T.getRandom(0, (this.area.width - 1) * (this.area.height - 1));
                Enemigo enemigo = new Enemigo(id);
                if (this.puntos.get(r) == null) {
                    --i;
                } else {
                    enemigo.setPos(this.puntos.get((int)r).x * 32, this.puntos.get((int)r).y * 32);
                    enemigos.add(enemigo);
                }
                ++i;
            }
        }
    }

    public void actualizar() {
        int enemigosActuales = 0;
        for (Enemigo enemigo : this.enemigos) {
            if (enemigo.id != this.id || !this.area.intersects(new Rectangle((int)(enemigo.posX / 32.0), (int)(enemigo.posY / 32.0), 1, 1))) continue;
            ++enemigosActuales;
        }
        if (enemigosActuales < this.minEnemigos) {
            int i = enemigosActuales;
            while (i < this.maxEnemigos) {
                int r = (int)T.getRandom(0, (this.area.width - 1) * (this.area.height - 1));
                Enemigo enemigo = new Enemigo(this.id);
                if (this.puntos.get(r) == null) {
                    --i;
                } else {
                    enemigo.setPos(this.puntos.get((int)r).x * 32, this.puntos.get((int)r).y * 32);
                    this.enemigos.add(enemigo);
                }
                ++i;
            }
        }
    }
}

