/*
 * Decompiled with CFR 0.152.
 */
package principal.entes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import principal.Constantes;
import principal.ElementosPrincipales;
import principal.dijkstra.Nodo;
import principal.elementos_jugador.Estado;
import principal.elementos_jugador.inventario.Objeto;
import principal.elementos_jugador.inventario.RegistroElementos;
import principal.herramientas.CargadorRecursos;
import principal.herramientas.DibujoDebug;
import principal.herramientas.T;
import principal.mapas.MapaTiled;
import principal.sprites.HojaSprites;

public class Enemigo {
    int id;
    private Rectangle areaDeteccionRelativa;
    private Rectangle areaDeteccion;
    public double posX = 0.0;
    public double posY = 0.0;
    public Nodo siguienteNodo;
    public boolean jugadorDetectado;
    public boolean choco;
    public boolean enMovimiento;
    protected int contadorActualizacion;
    protected int direccion = 0;
    int animacion = 0;
    int framesAnim;
    double segsAnim;
    public Estado estado;
    public int lado;
    private static HojaSprites[] hojas = new HojaSprites[3];
    public ArrayList<Objeto> drops = new ArrayList();

    public Enemigo(int id) {
        this.id = id;
        String infoString = CargadorRecursos.leerArchivoTexto("enemigos/" + (id + 1) + ".json");
        JSONObject info = T.getObjetoJSON(infoString);
        JSONArray estados = (JSONArray)info.get("estados");
        this.estado = new Estado((JSONObject)estados.get((int)T.getRandom(0, estados.size())), false);
        this.lado = T.getIntJSON(info, "lado");
        this.areaDeteccionRelativa = new Rectangle((int)(-Math.tanh(this.estado.sentidos) * 32.0 * 10.0), (int)(-Math.tanh(this.estado.sentidos) * 32.0 * 10.0), (int)(Math.tanh(this.estado.sentidos) * 32.0 * 20.0), (int)(Math.tanh(this.estado.sentidos) * 32.0 * 20.0));
        this.areaDeteccion = new Rectangle(this.areaDeteccionRelativa);
        JSONObject rutas = (JSONObject)info.get("rutas");
        if (hojas[id] == null) {
            Enemigo.hojas[id] = new HojaSprites(String.valueOf(Constantes.CARPETA_ENEMIGOS) + (id + 1) + ".png", this.lado, false);
        }
        JSONObject animacion = T.getObjetoJSON(info.get("animacion").toString());
        this.framesAnim = T.getIntJSON(animacion, "frames");
        this.segsAnim = T.getDoubJSON(animacion, "segs");
        JSONArray dropsJSON = T.getArrayJSON(info.get("drops").toString());
        int i = 0;
        while (i < dropsJSON.size()) {
            JSONObject drop = T.getObjetoJSON(dropsJSON.get(i).toString());
            int dropId = T.getIntJSON(drop, "id");
            int count = T.getIntJSON(drop, "count");
            Objeto objeto = RegistroElementos.getObjeto(dropId);
            objeto.cantidad = count;
            this.drops.add(objeto);
            ++i;
        }
    }

    public void actualizar(MapaTiled mapa) {
        int puntoX = (int)(this.posX - ElementosPrincipales.jugador.posX + (double)Constantes.CENTRO_MARGEN_X);
        int puntoY = (int)(this.posY - ElementosPrincipales.jugador.posY + (double)Constantes.CENTRO_MARGEN_Y);
        this.areaDeteccion.x = this.areaDeteccionRelativa.x + puntoX;
        this.areaDeteccion.y = this.areaDeteccionRelativa.y + puntoY;
        Point puntoMapa = new Point((int)(this.posX / 32.0), (int)(this.posY / 32.0));
        Point puntoJugador = ElementosPrincipales.jugador.getPosicionMapa();
        if (this.areaDeteccion.intersects(ElementosPrincipales.jugador.areaJugador)) {
            Nodo nodo;
            this.jugadorDetectado = true;
            if (this.contadorActualizacion % 30 == 0 && mapa.d != null && (nodo = mapa.d.encontrarSiguienteNodoEnemigo(puntoMapa)) != null) {
                this.siguienteNodo = new Nodo(nodo.pos, nodo.distancia);
            }
            if (this.siguienteNodo != null) {
                double velocidad = ((double)this.estado.agilidad / (double)this.estado.strenght * 10.0 - (double)this.estado.agilidad / (double)this.estado.strenght * 10.0 % 1.0) / 10.0;
                if (this.siguienteNodo.distancia != -1.0) {
                    Point puntoNodo = new Point(this.siguienteNodo.pos.x + mapa.d.centroMapa.x, this.siguienteNodo.pos.y + mapa.d.centroMapa.y);
                    double posXf = this.posX;
                    double posYf = this.posY;
                    int xSiguienteNodo = puntoNodo.x * 32;
                    int ySiguienteNodo = puntoNodo.y * 32;
                    if (this.posX < (double)xSiguienteNodo) {
                        this.direccion = 2;
                        this.mover(posXf += velocidad, posYf, mapa);
                        this.posX = Math.ceil(this.posX);
                    }
                    if (this.posX > (double)xSiguienteNodo) {
                        this.direccion = 3;
                        this.mover(posXf -= velocidad, posYf, mapa);
                        this.posX = Math.floor(this.posX);
                    }
                    if (this.posY < (double)ySiguienteNodo) {
                        this.direccion = 0;
                        this.mover(posXf, posYf += velocidad, mapa);
                        this.posY = Math.ceil(this.posY);
                    }
                    if (this.posY > (double)ySiguienteNodo) {
                        this.direccion = 1;
                        this.mover(posXf, posYf -= velocidad, mapa);
                        this.posY = Math.floor(this.posY);
                    }
                    if (this.enMovimiento) {
                        this.animar();
                    }
                }
            } else {
                this.animacion = 0;
            }
            this.estado.actualizar();
            if (this.getArea().intersects(ElementosPrincipales.jugador.areaJugador)) {
                this.estado.atacar(ElementosPrincipales.jugador.estado, 1);
            }
        } else {
            this.jugadorDetectado = false;
        }
        this.contadorActualizacion = this.contadorActualizacion >= 600 ? 0 : ++this.contadorActualizacion;
    }

    public void animar() {
        int actBFrame = (int)(60.0 / ((double)this.framesAnim / this.segsAnim));
        if (this.contadorActualizacion % actBFrame == 0) {
            ++this.animacion;
            if (this.animacion >= this.framesAnim) {
                this.animacion = 0;
            }
        }
    }

    public void dibujar(Graphics g, int puntoX, int puntoY) {
        DibujoDebug.dibujarImagen(g, hojas[this.id].getSprite(this.direccion, this.animacion).getImagen(), puntoX, puntoY);
        g.setFont(g.getFont().deriveFont(8.0f));
        DibujoDebug.dibujarString(g, String.valueOf(this.estado.nombre) + " Nv:" + this.estado.nivel, puntoX, puntoY - 8, Color.red);
        g.setFont(g.getFont().deriveFont(12.0f));
        int anchoBarra = (int)((double)this.lado / this.estado.HPMax * this.estado.HP);
        DibujoDebug.dibujarRectanguloRelleno(g, puntoX, puntoY - 5, anchoBarra, 2, Color.red);
    }

    public void perderVida(float ataqueRecibido) {
        this.estado.HP = this.estado.HP - (double)ataqueRecibido < 0.0 ? 0.0 : (this.estado.HP -= (double)ataqueRecibido);
    }

    public void mover(double posXf, double posYf, MapaTiled mapa) {
        Rectangle rf = new Rectangle((int)posXf, (int)posYf, this.lado, this.lado);
        boolean intersecta = false;
        for (Rectangle solido : mapa.areasColisionOriginales) {
            if (!rf.intersects(solido)) continue;
            intersecta = true;
            break;
        }
        for (Enemigo e : mapa.enemigosMapa) {
            if (e.equals(this) || !rf.intersects(e.getAreaPosicional())) continue;
            intersecta = true;
            break;
        }
        if (!intersecta) {
            this.posX = posXf;
            this.posY = posYf;
        }
        this.posX = T.limitarDecimales(this.posX, 1.0);
        this.posY = T.limitarDecimales(this.posY, 1.0);
        this.enMovimiento = true;
    }

    public void setPos(double posX, double posY) {
        this.posX = posX;
        this.posY = posY;
    }

    public Rectangle getArea() {
        int puntoX = (int)(this.posX - ElementosPrincipales.jugador.posX + (double)Constantes.CENTRO_MARGEN_X);
        int puntoY = (int)(this.posY - ElementosPrincipales.jugador.posY + (double)Constantes.CENTRO_MARGEN_Y);
        return new Rectangle(puntoX, puntoY, this.lado, this.lado);
    }

    public Rectangle getAreaPosicional() {
        return new Rectangle((int)this.posX, (int)this.posY, this.lado, this.lado);
    }
}

