/*
 * Decompiled with CFR 0.152.
 */
package principal.elementos_jugador.inventario;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import principal.Constantes;
import principal.ElementosPrincipales;
import principal.control.GestorControles;
import principal.elementos_jugador.inventario.RegistroElementos;
import principal.herramientas.DibujoDebug;
import principal.herramientas.T;
import principal.sprites.HojaSprites;
import principal.sprites.Sprite;

public abstract class Objeto {
    protected final String descripcion;
    public static HojaSprites hojaUniv;
    public int id;
    public Point posMapa;
    public Point posMenu = new Point();
    public Point posRaton = new Point();
    public boolean enJuego;
    public boolean enToolbar;
    public boolean enRaton;
    public int ranToolbar;
    public final String nombre;
    public int rango;
    public int cantidad;
    protected int cantidadMaxima;
    public int ranuraInventario;

    public Objeto(int id, String nombre, String descripcion, int rango) {
        this.id = id;
        this.rango = rango;
        this.nombre = nombre;
        this.enJuego = false;
        this.enToolbar = false;
        if (hojaUniv == null) {
            hojaUniv = new HojaSprites(Constantes.RUTA_HOJA_OBJETOS, 32, false);
        }
        this.descripcion = descripcion;
        this.cantidad = 1;
        this.cantidadMaxima = 99;
    }

    public void actualizar() {
        if (!this.enToolbar && GestorControles.teclado.recogiendo && this.id != 0) {
            int puntoX = (int)((double)this.posMapa.x - ElementosPrincipales.jugador.posX + (double)Constantes.CENTRO_MARGEN_X);
            int puntoY = (int)((double)this.posMapa.y - ElementosPrincipales.jugador.posY + (double)Constantes.CENTRO_MARGEN_Y);
            Rectangle r = new Rectangle(puntoX, puntoY, 32, 32);
            if (r.intersects(ElementosPrincipales.jugador.areaJugador)) {
                this.agarrar();
            }
        } else if (GestorControles.teclado.atacando && this.enToolbar) {
            this.usar();
        }
    }

    public boolean incrementarCantidad(int incremento) {
        boolean incrementado = false;
        if (this.cantidad + incremento <= this.cantidadMaxima) {
            this.cantidad += incremento;
            incrementado = true;
        }
        return incrementado;
    }

    public boolean reducirCantidad(int decremento) {
        boolean reducido = false;
        if (this.cantidad - decremento >= 0) {
            this.cantidad -= decremento;
            reducido = true;
        }
        if (this.cantidad < 1) {
            this.eliminar();
        }
        return reducido;
    }

    private void eliminar() {
        if (this.enToolbar) {
            ElementosPrincipales.jugador.toolbar.elementos[this.ranToolbar] = RegistroElementos.getObjeto(0);
        } else {
            ElementosPrincipales.jugador.inventario.objetos.remove(this);
        }
    }

    public void agarrar() {
        ElementosPrincipales.jugador.inventario.recogerObjeto(this);
        this.enJuego = false;
    }

    public void usar() {
    }

    public void dibujar(Graphics g) {
        if (this.enJuego) {
            if (!this.enToolbar) {
                int puntoX = (int)((double)this.posMapa.x - ElementosPrincipales.jugador.posX + (double)Constantes.CENTRO_MARGEN_X);
                int puntoY = (int)((double)this.posMapa.y - ElementosPrincipales.jugador.posY + (double)Constantes.CENTRO_MARGEN_Y);
                if (puntoX + 32 < 0 || puntoX > Constantes.ANCHO_JUEGO || puntoY + 32 < 0 || puntoY > Constantes.ALTO_JUEGO) {
                    return;
                }
                DibujoDebug.dibujarImagen(g, hojaUniv.getSprite(this.id).getImagen(), puntoX, puntoY);
            }
        } else if (this.id != 0) {
            if (this.enRaton) {
                DibujoDebug.dibujarImagen(g, hojaUniv.getSprite(this.id).getImagen(), this.posRaton);
                g.setFont(g.getFont().deriveFont(10.0f));
                DibujoDebug.dibujarRectanguloRelleno(g, this.posRaton.x, this.posRaton.y - T.MedirAltoPixeles(g, "" + this.cantidad) + 32 + 2, T.MedirAnchoPixeles(g, "" + this.cantidad), T.MedirAltoPixeles(g, "" + this.cantidad) - 2, Color.BLACK);
                DibujoDebug.dibujarString(g, "" + this.cantidad, this.posRaton.x, this.posRaton.y + 32, Color.white);
                g.setFont(g.getFont().deriveFont(12.0f));
            } else {
                DibujoDebug.dibujarImagen(g, hojaUniv.getSprite(this.id).getImagen(), this.posMenu);
                g.setFont(g.getFont().deriveFont(10.0f));
                DibujoDebug.dibujarRectanguloRelleno(g, this.posMenu.x, this.posMenu.y - T.MedirAltoPixeles(g, "" + this.cantidad) + 32 + 2, T.MedirAnchoPixeles(g, "" + this.cantidad), T.MedirAltoPixeles(g, "" + this.cantidad) - 2, Color.black);
                DibujoDebug.dibujarString(g, "" + this.cantidad, this.posMenu.x, this.posMenu.y + 32, Color.white);
                g.setFont(g.getFont().deriveFont(12.0f));
            }
        }
    }

    public Sprite getSprite() {
        return hojaUniv.getSprite(this.id);
    }

    public void setPosMapa(Point pos) {
        this.posMapa = new Point(pos.x * 32, pos.y * 32);
    }

    public void setEnMapa() {
        this.enJuego = true;
        this.enToolbar = false;
    }
}

