/*
 * Decompiled with CFR 0.152.
 */
package principal.elementos_jugador;

import org.json.simple.JSONObject;
import principal.ElementosPrincipales;
import principal.herramientas.CargadorRecursos;
import principal.herramientas.T;

public class Estado {
    public String nombre;
    public int nivel;
    public int exp;
    public int expMax;
    public int vitalidad;
    public int strenght;
    public int agilidad;
    public int sentidos;
    public int inteligencia;
    public int wisdom;
    public int luck;
    public int charm;
    public int puntosEstado;
    public int multEspecie;
    public double HP;
    public double HPMax;
    public double MP;
    public double MPMax;
    public double Stm;
    public double StmMax;
    public double Cal;
    public double CalMax;
    public boolean recuperandoHP = true;
    public boolean recuperandoMP = true;
    public boolean recuperandoStm = true;
    public double MaxcooldownAtaque;
    public double cooldownAtaque = 0.0;
    public boolean jugador;

    public Estado(String ruta, boolean jugador) {
        JSONObject info = T.getObjetoJSON(CargadorRecursos.leerArchivoTexto(ruta));
        this.iniciar(info, jugador);
    }

    public Estado(JSONObject info, boolean jugador) {
        this.iniciar(info, jugador);
    }

    public void iniciar(JSONObject info, boolean jugador) {
        this.jugador = jugador;
        if (jugador) {
            this.nombre = (String)info.get("nombre");
            this.vitalidad = T.getIntJSON(info, "vit");
            this.strenght = T.getIntJSON(info, "str");
            this.agilidad = T.getIntJSON(info, "agi");
            this.sentidos = T.getIntJSON(info, "sen");
            this.inteligencia = T.getIntJSON(info, "int");
            this.wisdom = T.getIntJSON(info, "wis");
            this.luck = T.getIntJSON(info, "luk");
            this.charm = T.getIntJSON(info, "cha");
            this.puntosEstado = T.getIntJSON(info, "puntosestado");
            this.nivel = (this.vitalidad + this.strenght + this.agilidad + this.sentidos + this.inteligencia + this.wisdom + this.luck + this.charm) / 10;
            if (this.nivel <= 0) {
                this.nivel = 1;
            }
            this.expMax = 10;
            int i = 1;
            while (i < this.nivel) {
                this.expMax += this.expMax / 7;
                ++i;
            }
            this.exp = T.getIntJSON(info, "exp");
            this.HPMax = this.vitalidad * this.strenght;
            this.MPMax = this.inteligencia * this.wisdom;
            this.StmMax = this.agilidad * this.vitalidad * 10;
            this.CalMax = this.HPMax * 200.0;
            this.HP = this.HPMax;
            this.MP = this.MPMax;
            this.Stm = this.StmMax;
            this.Cal = this.CalMax;
            this.MaxcooldownAtaque = (double)this.strenght / (double)this.agilidad * 60.0;
            if (this.MaxcooldownAtaque < 1.0) {
                this.MaxcooldownAtaque = 1.0;
            }
        } else {
            this.nombre = (String)info.get("nombre");
            this.vitalidad = T.getIntJSON(info, "vit");
            this.strenght = T.getIntJSON(info, "str");
            this.agilidad = T.getIntJSON(info, "agi");
            this.sentidos = T.getIntJSON(info, "sen");
            this.inteligencia = T.getIntJSON(info, "int");
            this.wisdom = T.getIntJSON(info, "wis");
            this.luck = T.getIntJSON(info, "luk");
            this.charm = T.getIntJSON(info, "cha");
            this.multEspecie = T.getIntJSON(info, "multespecie");
            this.nivel = (this.vitalidad + this.strenght + this.agilidad + this.sentidos + this.inteligencia + this.wisdom + this.luck + this.charm) / 10;
            if (this.nivel <= 0) {
                this.nivel = 1;
            }
            this.expMax = 10;
            this.exp = 10;
            int i = 1;
            while (i < this.nivel) {
                this.expMax += this.expMax / 7;
                this.exp += this.expMax;
                ++i;
            }
            this.puntosEstado = 0;
            this.HPMax = this.vitalidad * this.multEspecie;
            this.MPMax = this.inteligencia * this.multEspecie;
            this.StmMax = this.agilidad * 10;
            this.CalMax = this.HPMax * 200.0;
            this.HP = this.HPMax;
            this.MP = this.MPMax;
            this.Stm = this.StmMax;
            this.Cal = this.CalMax;
            this.MaxcooldownAtaque = (double)this.strenght / (double)this.agilidad * 60.0;
            if (this.MaxcooldownAtaque < 1.0) {
                this.MaxcooldownAtaque = 1.0;
            }
        }
    }

    public void actualizar() {
        if (this.jugador) {
            if (this.HP < this.HPMax && this.Cal >= 20.0 && this.recuperandoMP) {
                this.HP += this.HPMax * 0.01 / 60.0;
                this.Cal -= this.HPMax * 0.01 / 60.0 * 20.0;
            }
            if (this.MP < this.MPMax && this.recuperandoMP) {
                this.MP += this.MPMax * 0.01 / 60.0;
            }
            if (this.Stm < this.StmMax && this.Cal >= 1.0 && this.recuperandoStm) {
                this.Stm += this.StmMax * 0.01 / 60.0;
                this.Cal -= this.StmMax * 0.01 / 60.0;
            }
            if (this.HP > this.HPMax) {
                this.HP = this.HPMax;
            }
            if (this.MP > this.MPMax) {
                this.MP = this.MPMax;
            }
            if (this.Stm > this.StmMax) {
                this.Stm = this.StmMax;
            }
        } else {
            if (this.HP < this.HPMax && this.Cal >= 20.0 && this.recuperandoMP) {
                this.HP += this.HPMax * 0.01 / 3600.0;
                this.Cal -= this.HPMax * 0.01 / 3600.0 * 20.0;
            }
            if (this.MP < this.MPMax && this.recuperandoMP) {
                this.MP += this.MPMax * 0.01 / 3600.0;
            }
            if (this.Stm < this.StmMax && this.Cal >= 1.0 && this.recuperandoStm) {
                this.Stm += this.StmMax * 0.01 / 3600.0;
                this.Cal -= this.StmMax * 0.01 / 3600.0;
            }
        }
        if (this.cooldownAtaque > 0.0) {
            this.cooldownAtaque -= 1.0;
        }
    }

    public void actualizarEstadisticas(String estadistica, boolean positivo) {
        block58: {
            block57: {
                if (!positivo) break block57;
                if (this.puntosEstado <= 0) break block58;
                switch (estadistica) {
                    case "vit": {
                        ++this.vitalidad;
                        break;
                    }
                    case "str": {
                        ++this.strenght;
                        break;
                    }
                    case "agi": {
                        ++this.agilidad;
                        break;
                    }
                    case "sen": {
                        ++this.sentidos;
                        break;
                    }
                    case "int": {
                        ++this.inteligencia;
                        break;
                    }
                    case "wis": {
                        ++this.wisdom;
                        break;
                    }
                    case "luk": {
                        ++this.luck;
                        break;
                    }
                    case "cha": {
                        ++this.charm;
                    }
                }
                --this.puntosEstado;
                break block58;
            }
            switch (estadistica) {
                case "vit": {
                    if (this.vitalidad <= 1) break;
                    --this.vitalidad;
                    ++this.puntosEstado;
                    break;
                }
                case "str": {
                    if (this.strenght <= 1) break;
                    --this.strenght;
                    ++this.puntosEstado;
                    break;
                }
                case "agi": {
                    if (this.agilidad <= 1) break;
                    --this.agilidad;
                    ++this.puntosEstado;
                    break;
                }
                case "sen": {
                    if (this.sentidos <= 1) break;
                    --this.sentidos;
                    ++this.puntosEstado;
                    break;
                }
                case "int": {
                    if (this.inteligencia <= 1) break;
                    --this.inteligencia;
                    ++this.puntosEstado;
                    break;
                }
                case "wis": {
                    if (this.wisdom <= 1) break;
                    --this.wisdom;
                    ++this.puntosEstado;
                    break;
                }
                case "luk": {
                    if (this.luck <= 1) break;
                    --this.luck;
                    ++this.puntosEstado;
                    break;
                }
                case "cha": {
                    if (this.charm <= 1) break;
                    --this.charm;
                    ++this.puntosEstado;
                }
            }
        }
        this.HPMax = this.vitalidad * this.strenght;
        this.MPMax = this.inteligencia * this.wisdom;
        this.StmMax = this.agilidad * this.vitalidad * 10;
        this.CalMax = this.HPMax * 200.0;
        this.MaxcooldownAtaque = (double)this.strenght / (double)this.agilidad * 60.0;
        if (this.MaxcooldownAtaque < 1.0) {
            this.MaxcooldownAtaque = 1.0;
        }
    }

    public void perderVida(Estado estadoAtk, int multArma) {
        double multArea = Math.tanh((double)(estadoAtk.agilidad * this.strenght) * T.getRandom(1, 100) / (double)(this.agilidad * estadoAtk.strenght * 125)) * 10.0 + 0.2;
        int def = (this.vitalidad + this.strenght) / 2;
        int ataque = (int)((double)estadoAtk.strenght * multArea * (double)multArma / (double)def);
        this.HP -= (double)ataque;
        if (!this.jugador && this.HP <= 0.0) {
            ElementosPrincipales.jugador.estado.actualizarExp(this.exp / 7);
        }
    }

    public void atacar(Estado estadoVictima, int multArma) {
        if (this.cooldownAtaque < 1.0) {
            estadoVictima.perderVida(this, multArma);
            this.cooldownAtaque = this.MaxcooldownAtaque;
        }
    }

    public void actualizarExp(int aumento) {
        this.exp += aumento;
        while (this.exp > this.expMax) {
            this.exp -= this.expMax;
            ++this.nivel;
            this.puntosEstado += 10;
            this.expMax += this.expMax / 7;
        }
    }
}

