/*
 * Decompiled with CFR 0.152.
 */
package principal.dijkstra;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import principal.Constantes;
import principal.ElementosPrincipales;
import principal.dijkstra.Nodo;
import principal.herramientas.DibujoDebug;

public class Dijkstra {
    private int ancho;
    private int alto;
    private int lado = 32;
    private int checkpoint;
    public Point centroCalculoAnterior;
    private ArrayList<Nodo> nodosLibres;
    private boolean constructor = true;
    private boolean termino = false;
    public Point centroMapa;

    public Dijkstra(Point centroCalculoMapa, Rectangle areaDeteccion, ArrayList<Rectangle> zonasSolidas) {
        this.ancho = areaDeteccion.width / this.lado + 1;
        this.alto = areaDeteccion.height / this.lado + 1;
        this.centroMapa = new Point(areaDeteccion.x / this.lado - 1, areaDeteccion.y / this.lado - 1);
        this.nodosLibres = new ArrayList();
        int y = 0;
        while (y < this.alto) {
            int x = 0;
            while (x < this.ancho) {
                Rectangle ubicacionNodo = new Rectangle((x + this.centroMapa.x) * this.lado, (y + this.centroMapa.y) * this.lado, this.lado, this.lado);
                boolean transitable = true;
                for (Rectangle area : zonasSolidas) {
                    if (!ubicacionNodo.intersects(area)) continue;
                    transitable = false;
                    break;
                }
                if (transitable) {
                    Nodo nodo = new Nodo(new Point(x, y), -1.0);
                    this.nodosLibres.add(nodo);
                }
                ++x;
            }
            ++y;
        }
        this.reiniciarYEvaluar(centroCalculoMapa);
        this.constructor = false;
    }

    public boolean reiniciarYEvaluar(Point centroCalculoMapa) {
        if (!this.constructor && !centroCalculoMapa.equals(this.centroCalculoAnterior)) {
            this.termino = false;
            this.checkpoint = 0;
            this.centroCalculoAnterior = centroCalculoMapa;
            for (Nodo nodo : this.nodosLibres) {
                nodo.distancia = -1.0;
            }
        }
        boolean tieneCentro = false;
        Point centroCalculo = new Point(centroCalculoMapa.x - this.centroMapa.x, centroCalculoMapa.y - this.centroMapa.y);
        for (Nodo nodo : this.nodosLibres) {
            if (!nodo.pos.equals(centroCalculo)) continue;
            nodo.distancia = 0.0;
            tieneCentro = true;
            break;
        }
        if (!tieneCentro && !this.constructor) {
            return false;
        }
        boolean cambiado = false;
        int i = 0;
        int max = this.nodosLibres.size() / 120;
        if (max < 1) {
            max = 1;
        }
        while (!cambiado && i < max) {
            cambiado = true;
            int cambios = 0;
            for (Nodo nodo : this.nodosLibres) {
                if (nodo.distancia == -1.0) {
                    cambiado = false;
                    continue;
                }
                int yInicial = nodo.pos.y;
                int xInicial = nodo.pos.x;
                int y = yInicial - 1;
                while (y < yInicial + 2) {
                    int x = xInicial - 1;
                    while (x < xInicial + 2) {
                        int indiceNodo;
                        if (!(x <= -1 || y <= -1 || x >= this.ancho || y >= this.alto || x == xInicial && y == yInicial || (indiceNodo = this.getIndiceNodoPorPos(new Point(x, y))) == -1 || this.nodosLibres.get((int)indiceNodo).distancia != -1.0 || xInicial != x && yInicial != y)) {
                            double distancia = 1.0;
                            this.nodosLibres.get((int)indiceNodo).distancia = nodo.distancia + distancia;
                        }
                        ++x;
                    }
                    ++y;
                }
                ++cambios;
            }
            if (cambios == 0) break;
            ++i;
        }
        this.checkpoint += i;
        this.termino = this.checkpoint >= this.nodosLibres.size();
        return true;
    }

    private int getIndiceNodoPorPos(Point posicion) {
        for (Nodo nodo : this.nodosLibres) {
            if (!nodo.pos.equals(posicion)) continue;
            return this.nodosLibres.indexOf(nodo);
        }
        return -1;
    }

    public Point getCoordenadasNodoConsiguiente(Point puntoJugador) {
        Rectangle rectanguloPuntoExacto = new Rectangle(puntoJugador.x / this.lado, puntoJugador.y / this.lado, 1, 1);
        Point puntoExacto = null;
        for (Nodo nodo : this.nodosLibres) {
            if (!nodo.getArea().intersects(rectanguloPuntoExacto)) continue;
            puntoExacto = new Point(rectanguloPuntoExacto.x, rectanguloPuntoExacto.y);
            return puntoExacto;
        }
        return puntoExacto;
    }

    private ArrayList<Nodo> getNodosVecinos(Nodo nodo) {
        int inicialY = nodo.pos.y;
        int inicialX = nodo.pos.x;
        ArrayList<Nodo> nodosVecinos = new ArrayList<Nodo>();
        int y = inicialY - 1;
        while (y < inicialY + 2) {
            int x = inicialX - 1;
            while (x < inicialX + 2) {
                int indiceNodo;
                if (x > -1 && y > -1 && x < this.ancho && y < this.alto && (x != inicialX || y != inicialY) && (indiceNodo = this.getIndiceNodoPorPos(new Point(x, y))) != -1) {
                    nodosVecinos.add(this.nodosLibres.get(indiceNodo));
                }
                ++x;
            }
            ++y;
        }
        return nodosVecinos;
    }

    public Nodo encontrarSiguienteNodoEnemigo(Point puntoOrigenMapa) {
        ArrayList<Object> nodosAfectados = new ArrayList();
        Point puntoOrigen = new Point(puntoOrigenMapa.x - this.centroMapa.x, puntoOrigenMapa.y - this.centroMapa.y);
        Nodo siguienteNodo = null;
        boolean origenTieneNodo = false;
        int i = 0;
        while (!origenTieneNodo && i < this.nodosLibres.size()) {
            for (Nodo nodo : this.nodosLibres) {
                int indiceNodo;
                Point p = new Point(puntoOrigen.x + i, puntoOrigen.y + i);
                if (!p.equals(nodo.pos) || (double)(indiceNodo = this.getIndiceNodoPorPos(p)) == -1.0) continue;
                Nodo nodoOrigen = this.nodosLibres.get(indiceNodo);
                nodosAfectados = this.getNodosVecinos(nodoOrigen);
                origenTieneNodo = true;
                break;
            }
            ++i;
        }
        if (nodosAfectados != null) {
            i = 0;
            while (i < nodosAfectados.size()) {
                if (i == 0) {
                    siguienteNodo = (Nodo)nodosAfectados.get(0);
                } else if ((siguienteNodo.distancia > ((Nodo)nodosAfectados.get((int)i)).distancia || siguienteNodo.distancia == -1.0) && ((Nodo)nodosAfectados.get((int)i)).distancia != -1.0) {
                    siguienteNodo = (Nodo)nodosAfectados.get(i);
                }
                ++i;
            }
        }
        return siguienteNodo;
    }

    public void dibujar(Graphics g) {
        for (Nodo nodo : this.nodosLibres) {
            Point puntoMapa = new Point(nodo.pos.x + this.centroMapa.x, nodo.pos.y + this.centroMapa.y);
            int puntoX = puntoMapa.x * this.lado - (int)ElementosPrincipales.jugador.posX + Constantes.CENTRO_MARGEN_X;
            int puntoY = puntoMapa.y * this.lado - (int)ElementosPrincipales.jugador.posY + Constantes.CENTRO_MARGEN_Y;
            DibujoDebug.dibujarRectangulo(g, puntoX, puntoY, this.lado, this.lado, Color.red);
            DibujoDebug.dibujarString(g, "" + nodo.distancia, puntoX, puntoY + this.lado);
        }
    }
}

