/*
 * Decompiled with CFR 0.152.
 */
package principal.control;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import principal.Constantes;
import principal.graficos.SuperficieDibujo;
import principal.herramientas.CargadorRecursos;
import principal.herramientas.DatosDebug;

public class Raton
extends MouseAdapter {
    public final Cursor cursor;
    public Point posicion;
    public boolean click;
    public boolean click2;

    public Raton(SuperficieDibujo sd) {
        Toolkit configuracion = Toolkit.getDefaultToolkit();
        BufferedImage icono = CargadorRecursos.cargarImagenCompatibleTranslucida(Constantes.RUTA_CURSOR);
        Constantes.LADO_CURSOR = icono.getHeight();
        Point punta = new Point(0, 0);
        this.cursor = configuracion.createCustomCursor(icono, punta, "Cursor por defecto");
        this.posicion = new Point();
        this.click = false;
        this.click2 = false;
        Point posicionInicial = MouseInfo.getPointerInfo().getLocation();
        this.posicion.setLocation(posicionInicial);
        SwingUtilities.convertPointFromScreen(this.posicion, sd);
    }

    public void actualizar(SuperficieDibujo sd) {
        Point posicionInicial = MouseInfo.getPointerInfo().getLocation();
        this.posicion.setLocation(posicionInicial);
        SwingUtilities.convertPointFromScreen(this.posicion, sd);
    }

    public void dibujar(Graphics g) {
        DatosDebug.enviarDato("RX: " + this.posicion.x);
        DatosDebug.enviarDato("RY: " + this.posicion.y);
    }

    public Rectangle getRectanglePosicion() {
        Rectangle area = new Rectangle(this.posicion.x, this.posicion.y, 1, 1);
        return area;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.click = true;
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.click2 = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.click = false;
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.click2 = false;
        }
    }

    public Rectangle getRectanglePosicionEscalado() {
        Rectangle area = new Rectangle((int)((double)this.posicion.x / Constantes.FACTOR_ESCALADO_X), (int)((double)this.posicion.y / Constantes.FACTOR_ESCALADO_Y), 1, 1);
        return area;
    }
}

