/*
 * Decompiled with CFR 0.152.
 */
package principal;

import principal.Constantes;
import principal.graficos.SuperficieDibujo;
import principal.graficos.Ventana;
import principal.maquinaestado.GestorEstados;
import principal.sonido.SoundController;

public class GestorPrincipal {
    private boolean enFuncionamiento = false;
    private String titulo;
    private int ancho;
    private int alto;
    public static SuperficieDibujo sd;
    private Ventana ventana;
    public GestorEstados ge;
    public static int aps;
    public static int fps;

    static {
        aps = 0;
        fps = 0;
    }

    private GestorPrincipal(String titulo, int ancho, int alto) {
        this.titulo = titulo;
        this.ancho = ancho;
        this.alto = alto;
    }

    public static void main(String[] args) {
        System.setProperty("sun.java2d.d3d", "true");
        GestorPrincipal gp = new GestorPrincipal("EL JUEGO", Constantes.ANCHO_PANTALLA_COMPLETA, Constantes.ALTO_PANTALLA_COMPLETA);
        gp.iniciarJuego();
        gp.iniciarBuclePrincipal();
    }

    private void iniciarJuego() {
        this.enFuncionamiento = true;
        this.inicializar();
    }

    private void inicializar() {
        sd = new SuperficieDibujo(this.ancho, this.alto);
        this.ventana = new Ventana(this.titulo, sd);
        this.ge = new GestorEstados(sd);
    }

    private void iniciarBuclePrincipal() {
        int actualizacionesAcumuladas = 0;
        int framesAcumulados = 0;
        int NS_POR_SEGUNDO = 1000000000;
        int APS_OBJETIVO = 60;
        double NS_POR_ACTUALIZACION = 1.6666666E7;
        long referenciaContador = System.nanoTime();
        long referenciaActualizacion = System.nanoTime();
        double delta = 0.0;
        System.out.println("se inicio el bucle");
        while (this.enFuncionamiento) {
            long inicioBucle = System.nanoTime();
            double tiempoTranscurrido = inicioBucle - referenciaActualizacion;
            referenciaActualizacion = inicioBucle;
            delta += tiempoTranscurrido / 1.6666666E7;
            while (delta >= 1.0) {
                this.actualizar();
                ++actualizacionesAcumuladas;
                delta -= 1.0;
            }
            this.dibujar();
            ++framesAcumulados;
            if (System.nanoTime() - referenciaContador <= 1000000000L) continue;
            aps = actualizacionesAcumuladas;
            fps = framesAcumulados;
            this.ventana.setTitle(String.valueOf(this.titulo) + " // APS: " + aps + " // FPS: " + fps);
            actualizacionesAcumuladas = 0;
            framesAcumulados = 0;
            referenciaContador = System.nanoTime();
        }
    }

    private void dibujar() {
        sd.dibujar(this.ge);
    }

    private void actualizar() {
        this.ge.actualizar();
        sd.actualizar();
        SoundController.actualizar();
    }

    public static void salir() {
        System.exit(0);
    }
}

